/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SimpleModule
extends CompatModule {
    private final String shortId;
    private final Map<String, EntrySet<?>> entries = new LinkedHashMap();
    private final Set<Class<? extends BlockType>> affectedTypes = new HashSet<Class<? extends BlockType>>();
    protected int bloat = 0;

    public SimpleModule(String modId, String shortId) {
        super(modId);
        this.shortId = shortId;
    }

    public SimpleModule(String modId, String shortId, String myNamespace) {
        super(modId, myNamespace);
        this.shortId = shortId;
    }

    public ResourceLocation makeMyRes(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.getMyNamespace(), (String)name);
    }

    @Override
    public Collection<Class<? extends BlockType>> getAffectedTypes() {
        return this.affectedTypes;
    }

    @Override
    public int bloatAmount() {
        return this.bloat;
    }

    public <T extends BlockType, S extends EntrySet<T>> S addEntry(S entryHolder) {
        EntrySet<?> old = this.entries.put(entryHolder.getName(), entryHolder);
        if (old != null) {
            throw new UnsupportedOperationException(String.format("This module already has an entry set with name %s", entryHolder.getName()));
        }
        this.affectedTypes.add(entryHolder.getTypeClass());
        EveryCompat.trackChildType(entryHolder.getTypeClass(), entryHolder.getChildKey(this));
        return entryHolder;
    }

    public Collection<EntrySet<?>> getEntries() {
        return this.entries.values();
    }

    public EntrySet<?> getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public String shortenedId() {
        return this.shortId;
    }

    @Override
    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
        this.getEntries().forEach(e -> e.addTranslations(this, lang));
    }

    @Override
    public <T extends BlockType> void registerBlocks(Class<T> typeClass, Registrator<Block> registry, Collection<T> types) {
        int blockCount = 0;
        for (EntrySet<?> e : this.getEntries()) {
            if (!e.getTypeClass().isAssignableFrom(typeClass)) continue;
            this.registerBlocksTyped(registry, types, e);
            blockCount += e.getBlockCount();
        }
        this.bloat += blockCount;
        if (blockCount > 0) {
            EveryCompat.LOGGER.info("{}: registered {} {} blocks", (Object)this, (Object)blockCount, (Object)typeClass.getSimpleName());
        }
    }

    private <T extends BlockType> void registerBlocksTyped(Registrator<Block> registry, Collection<?> types, EntrySet<T> e) {
        e.registerBlocks(this, registry, types);
    }

    @Override
    public void registerItems(Registrator<Item> registry) {
        this.getEntries().forEach(e -> e.registerItems(this, registry));
    }

    @Override
    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
        this.getEntries().forEach(e -> e.registerTiles(this, registry));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> {
            e.generateLootTables(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateRecipes(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateTags(this, (DynamicDataPack)handler.dynamicPack, manager);
        });
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> {
            block2: {
                try {
                    e.generateModels(this, handler, manager);
                }
                catch (Exception ex) {
                    EveryCompat.LOGGER.error("Failed to generate models for entry set {}:", e, (Object)ex);
                    if (!PlatHelper.isDev()) break block2;
                    throw ex;
                }
            }
        });
        this.getEntries().forEach(e -> {
            block2: {
                try {
                    e.generateTextures(this, handler, manager);
                }
                catch (Exception ex) {
                    EveryCompat.LOGGER.error("Failed to generate textures for entry set {}:", e, (Object)ex);
                    if (!PlatHelper.isDev()) break block2;
                    throw ex;
                }
            }
        });
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        this.getEntries().forEach(e -> e.registerBlockColors(event));
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        this.getEntries().forEach(e -> e.registerItemColors(event));
    }

    @Override
    public void onClientSetup() {
        this.getEntries().forEach(EntrySet::setRenderLayer);
    }

    @Override
    public void onModSetup() {
        this.getEntries().forEach(EntrySet::setupExistingTiles);
    }

    public static void appendTileEntityBlocks(BlockEntityType<?> be, Collection<? extends Block> blocks) {
        be.validBlocks = new HashSet(be.validBlocks);
        be.validBlocks.addAll(blocks);
    }

    @Override
    public void registerItemsToExistingTabs(RegHelper.ItemToTabEvent event) {
        this.getEntries().forEach(e -> e.registerItemsToExistingTabs(this, event));
    }

    @Override
    public <T extends BlockType> List<Item> getAllItemsOfType(T type) {
        ArrayList<Item> l = new ArrayList<Item>();
        for (EntrySet<?> entrySet : this.entries.values()) {
            Item itemOfType;
            if (!entrySet.getTypeClass().isAssignableFrom(type.getClass()) || (itemOfType = entrySet.getItemForECTab(type)) == null) continue;
            l.add(itemOfType);
        }
        return l;
    }

    public boolean isEntryAlreadyRegistered(String blockId, BlockType blockType, Registry<?> registry) {
        LeavesType lt;
        WoodType wt;
        Boolean hardcoded;
        String blockName = blockId.substring(blockId.lastIndexOf("/") + 1);
        String woodTypeFrom = blockType.getNamespace();
        String slashConvention = woodTypeFrom + "/" + blockName;
        String underscoreConvention = woodTypeFrom + "_" + blockName;
        if (blockType instanceof WoodType ? (hardcoded = HardcodedBlockType.isWoodBlockAlreadyRegistered(blockName, wt = (WoodType)blockType, this.modId, this.shortenedId())) != null : blockType instanceof LeavesType && (hardcoded = HardcodedBlockType.isLeavesBlockAlreadyRegistered(blockName, lt = (LeavesType)blockType, this.modId, this.shortenedId())) != null) {
            return hardcoded;
        }
        if (this.getAlreadySupportedMods().contains(woodTypeFrom)) {
            return true;
        }
        if (woodTypeFrom.equals(this.modId)) {
            return true;
        }
        if ((registry.containsKey(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)blockName)) || registry.containsKey(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)underscoreConvention))) && WoodTypeRegistry.INSTANCE.get(this.modRes(blockType.getTypeName())) == null) {
            return true;
        }
        if (registry.containsKey(ResourceLocation.fromNamespaceAndPath((String)woodTypeFrom, (String)blockName))) {
            return true;
        }
        for (EveryCompat.CompatMod c : EveryCompat.getCompatMods()) {
            String compatModId = c.modId();
            if (!c.woodsFrom().contains(woodTypeFrom) || !c.blocksFrom().contains(this.modId)) continue;
            if (registry.containsKey(ResourceLocation.fromNamespaceAndPath((String)compatModId, (String)blockName))) {
                return true;
            }
            if (registry.containsKey(ResourceLocation.fromNamespaceAndPath((String)compatModId, (String)slashConvention))) {
                return true;
            }
            if (!registry.containsKey(ResourceLocation.fromNamespaceAndPath((String)compatModId, (String)underscoreConvention))) continue;
            return true;
        }
        return false;
    }
}

