/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class TagUtility {
    public static final ResourceLocation GLASS_TAG = TagUtility.commonTag("glass");
    public static final ResourceLocation GLASS_PANE_TAG = TagUtility.commonTag("glass_panes");

    public static ResourceLocation getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ServerDynamicResourcesHandler handler, ResourceManager manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        ResourceLocation RLocLogs = ResourceLocation.parse((String)(resLocMOD + "_" + suffixTag));
        ResourceLocation RLocStems = ResourceLocation.parse((String)(resLocMOD + "_" + suffixAlt));
        ResourceLocation RLocFolders = ResourceLocation.parse((String)(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName()));
        ResourceLocation RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (manager.getResource(ResType.TAGS.getPath(RLocLogs.withPrefix("blocks/"))).isPresent()) {
            return RLocLogs;
        }
        if (manager.getResource(ResType.TAGS.getPath(RLocStems.withPrefix("blocks/"))).isPresent()) {
            return RLocStems;
        }
        if (manager.getResource(ResType.TAGS.getPath(RLocEC.withPrefix("blocks/"))).isPresent()) {
            return RLocEC;
        }
        if (manager.getResource(ResType.TAGS.getPath(RLocFolders.withPrefix("blocks/"))).isPresent()) {
            return RLocFolders;
        }
        TagUtility.createAndAddDefaultTags(RLocEC, handler, blockType, new Block[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(ResourceLocation resLoc, ServerDynamicResourcesHandler handler, BlockType blockType, Block ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return TagUtility.createAndAddCustomTags(resLoc, handler, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return TagUtility.createAndAddCustomTags(resLoc, handler, blocks);
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ServerDynamicResourcesHandler handler, Block ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Block block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, Registries.BLOCK);
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, Registries.ITEM);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, String tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)tag));
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                Block block = (Block)entry.getValue();
                if (!stoneType.getTypeName().equals(nameStone)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.BLOCK);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.ITEM);
                }
            }
        }
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, TagKey<Block> tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                Block block = (Block)entry.getValue();
                if (!stoneType.getTypeName().equals(nameStone)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.BLOCK);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.ITEM);
                }
            }
        }
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String regexBlockId, String nameStone, String modId, TagKey<Block> tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                Block block = (Block)entry.getValue();
                String blockPath = Utils.getID((Block)block).getPath();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!stoneType.getTypeName().equals(nameStone) || !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.BLOCK);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.ITEM);
                }
            }
        }
    }

    public static Pair<ResourceLocation, Boolean> getATagId(String idTag, String idAlt, ResourceManager manager) {
        ResourceLocation RLocId = ResourceLocation.parse((String)idTag);
        ResourceLocation RLocIdAlt = ResourceLocation.parse((String)idAlt);
        if (TagUtility.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (TagUtility.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(ResourceLocation resLoc, ResourceManager manager) {
        boolean blockTag = manager.getResource(ResType.TAGS.getPath(resLoc.withPrefix("blocks/"))).isPresent();
        boolean itemTag = manager.getResource(ResType.TAGS.getPath(resLoc.withPrefix("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static ResourceLocation commonTag(String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)suffix);
    }
}

