/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ExtraTextureGenerator {
    private static final Gson GSON = new Gson();

    public static void generateExtraTextures(DynClientResourcesGenerator generator, ResourceManager manager) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)manager, (String)"recolorable_textures", (Gson)GSON, map);
        ArrayList extraTextures = new ArrayList();
        map.forEach((id, json) -> {
            RecolorableTexture modifier = (RecolorableTexture)((Pair)RecolorableTexture.CODEC.decode((DynamicOps)JsonOps.INSTANCE, json).getOrThrow()).getFirst();
            extraTextures.add(modifier);
        });
        for (RecolorableTexture v : extraTextures) {
            WoodType baseWood = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)v.block);
            SimpleEntrySet.Builder<WoodType, Block> dummy = SimpleEntrySet.builder(WoodType.class, "dummy", () -> v.block, () -> baseWood, w -> null);
            for (Text t : v.textures) {
                if (t.mask != null) {
                    dummy.addTextureM(t.text, t.mask);
                    continue;
                }
                dummy.addTexture(t.text);
            }
            if (v.mergePalette) {
                dummy.useMergedPalette();
            }
            dummy.build().generateTextures(null, generator, manager);
        }
    }

    public record RecolorableTexture(List<Text> textures, boolean mergePalette, Block block) {
        public static final Codec<RecolorableTexture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Text.TEXT_CODEC.listOf().fieldOf("textures").forGetter(RecolorableTexture::textures), (App)Codec.BOOL.optionalFieldOf("merge_palette", (Object)true).forGetter(RecolorableTexture::mergePalette), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("planks_block").forGetter(RecolorableTexture::block)).apply((Applicative)instance, RecolorableTexture::new));
    }

    public record Text(ResourceLocation text, @Nullable ResourceLocation mask) {
        public static final Codec<Text> TEXT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Text::text), (App)ResourceLocation.CODEC.optionalFieldOf("mask").forGetter(t -> Optional.ofNullable(t.mask))).apply((Applicative)instance, (a, b) -> new Text((ResourceLocation)a, b.orElse(null))));
    }
}

