/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.just_a_raft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.justaraftmod.entities.RaftType;
import com.mrbysco.justaraftmod.items.RaftItem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public class JustARaftModule
extends SimpleModule {
    public final ItemOnlyEntrySet<WoodType, Item> rafts;
    public final Map<WoodType, RaftType> raftTypes = new HashMap<WoodType, RaftType>();

    public JustARaftModule(String modId) {
        super(modId, "jar");
        ResourceLocation tab = this.modRes("tab");
        this.rafts = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(WoodType.class, "raft", this.getModItem("oak_raft"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new RaftItem(this.getRaftType((WoodType)woodType), new Item.Properties())).createPaletteFromChild("log", (Predicate)SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE)).addTextureM(this.modRes("entity/raft/oak_raft"), EveryCompat.res("entity/raft/oak_raft_m"))).addTag(this.modRes("rafts"), Registries.ITEM)).setTabKey(tab)).build();
        this.addEntry(this.rafts);
    }

    private RaftType getRaftType(WoodType w) {
        String name = this.shortenedId() + "/" + w.getAppendableId();
        return this.raftTypes.computeIfAbsent(w, woodType -> RaftType.registerRaftType((RaftType)new RaftType(w.planks, (Holder)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)EveryCompat.res(name + "_raft")), name, EveryCompat.res("textures/entity/raft/" + name + "_raft.png"))));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        ResourceLocation recipeLoc = ResType.RECIPES.getPath(this.modRes("oak_raft"));
        this.rafts.items.forEach((wood, item) -> {
            try (InputStream recipeStrem = ((Resource)manager.getResource(recipeLoc).orElseThrow(() -> new FileNotFoundException("Failed to open the recipe @ " + String.valueOf(recipeLoc)))).open();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStrem);
                recipe.getAsJsonObject("key").getAsJsonObject("L").addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", (BlockType)wood, handler, manager).toString());
                recipe.getAsJsonObject("result").addProperty("item", Utils.getID((Item)item).toString());
                String newRecipeLoc = this.shortenedId() + "/" + wood.getAppendableId() + "_raft";
                ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(newRecipeLoc), (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                handler.getLogger().error("Failed to generate recipes for {} : {}", item, (Object)e);
            }
        });
    }
}

