/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.valhelsia;

import com.mojang.blaze3d.platform.NativeImage;
import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.valhelsia.valhelsia_core.api.common.block.StrippableRotatedPillarBlock;

public class ValhelsiaStructuresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> cutStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> cutPosts;
    public final SimpleEntrySet<WoodType, Block> bundledStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> bundledPosts;

    public ValhelsiaStructuresModule(String modId) {
        super(modId, "vs");
        ResourceLocation tab = this.modRes("main");
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "stripped", this.getModBlock("stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new PostBlock(ValhelsiaStructuresModule.postProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("stripped_posts"), Registries.BLOCK)).addTag(this.modRes("stripped_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.strippedPosts);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", this.getModBlock("oak_post"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new StrippablePostBlock((WoodType)woodType, ValhelsiaStructuresModule.postProperties(woodType))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(this.modRes("posts"), Registries.BLOCK)).addTag(this.modRes("posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.posts);
        this.cutStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut_stripped", this.getModBlock("cut_stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new CutPostBlock(ValhelsiaStructuresModule.cutPostProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).addTag(this.modRes("cut_stripped_posts"), Registries.BLOCK)).addTag(this.modRes("cut_stripped_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutStrippedPosts);
        this.cutPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut", this.getModBlock("cut_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new StrippableCutPostBlock((WoodType)woodType, ValhelsiaStructuresModule.cutPostProperties(woodType))).addTag(this.modRes("cut_posts"), Registries.BLOCK)).addTag(this.modRes("cut_posts"), Registries.ITEM)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutPosts);
        this.bundledStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled_stripped", this.getModBlock("bundled_stripped_oak_posts"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new RotatedPillarBlock(ValhelsiaStructuresModule.bundledPostProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledStrippedPosts);
        this.bundledPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled", this.getModBlock("bundled_oak_posts"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new StrippableRotatedPillarBlock(() -> (Block)this.bundledStrippedPosts.blocks.get(woodType), ValhelsiaStructuresModule.bundledPostProperties(woodType))).requiresFromMap(this.bundledStrippedPosts.blocks)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledPosts);
    }

    public static BlockBehaviour.Properties postProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? Objects.requireNonNull(woodType.getBlockOfThis("stripped_log")).defaultMapColor() : woodType.log.defaultMapColor()).strength(2.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties cutPostProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(state -> ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getAxis().isVertical() && Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? Objects.requireNonNull(woodType.getBlockOfThis("stripped_log")).defaultMapColor() : woodType.log.defaultMapColor()).strength(2.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties bundledPostProperties(WoodType woodType) {
        return woodType.copyProperties().mapColor(state -> ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)).isVertical() && Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? MapColor.WOOD : MapColor.PODZOL).strength(2.0f).noOcclusion();
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        try {
            this.posts.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = logTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    handler.getLogger().error("Failed to generate Post block texture for for {} : {}", block, (Object)e);
                }
            });
            this.strippedPosts.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/stripped_oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = logTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    handler.getLogger().error("Failed to generate Stripped Post block texture for for {} : {}", block, (Object)e);
                }
            });
        }
        catch (Exception ex) {
            handler.getLogger().error("Could not generate any Table block texture : ", (Throwable)ex);
        }
        try (TextureImage BPTopInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_inner_m"));
             TextureImage BPTopOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_outer_m"));
             TextureImage logInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/log_top_inner_m"));
             TextureImage logOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/log_top_outer_m"));){
            this.bundledPosts.blocks.forEach((w, block) -> {
                String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_" + w.getTypeName() + "_posts";
                this.createTexture(newPath, w.log, logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_oak_posts"), this.modRes("block/bundled_posts/bundled_oak_posts_top"), handler, manager, (Block)block);
            });
            this.bundledStrippedPosts.blocks.forEach((w, block) -> {
                String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_stripped_" + w.getTypeName() + "_posts";
                this.createTexture(newPath, w.getBlockOfThis("stripped_log"), logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_stripped_oak_posts"), this.modRes("block/bundled_posts/bundled_stripped_oak_posts_top"), handler, manager, (Block)block);
            });
        }
        catch (Exception e) {
            handler.getLogger().error("Failed to open bundled_posts texture: ", (Throwable)e);
        }
    }

    private void createTexture(String newPath, Block getLogBlock, TextureImage logInnerMask, TextureImage logOuterMask, TextureImage BPTopInnerMask, TextureImage BPTopOuterMask, ResourceLocation getLogSide, ResourceLocation getLogTop, ClientDynamicResourcesHandler handler, ResourceManager manager, Block block) {
        try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
             TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));
             TextureImage TextureSide = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogSide);
             TextureImage TextureTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogTop);){
            TextureImage topImage;
            TextureImage sideImage;
            NativeImage standardSize;
            McMetaFile metaSide = logSide_texture.getMcMeta();
            if (Objects.nonNull(logSide_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.copyFrom(logSide_texture.getImage());
                sideImage = TextureImage.of((NativeImage)standardSize);
            } else {
                sideImage = logSide_texture;
            }
            List targetSide = Palette.fromAnimatedImage((TextureImage)sideImage);
            Respriter respriterSide = Respriter.of((TextureImage)TextureSide);
            TextureImage recoloredSIDE = respriterSide.recolorWithAnimation(targetSide, metaSide);
            handler.addTextureIfNotPresent(manager, newPath, () -> recoloredSIDE);
            recoloredSIDE.close();
            McMetaFile metaTop = logTop_texture.getMcMeta();
            if (Objects.nonNull(logTop_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.copyFrom(logTop_texture.getImage());
                topImage = TextureImage.of((NativeImage)standardSize);
            } else {
                topImage = logTop_texture;
            }
            List targetTopInner = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logOuterMask, (float)0.0f);
            List targetTopOuter = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logInnerMask, (float)0.0f);
            Respriter innerTopResp = Respriter.masked((TextureImage)TextureTop, (TextureImage)BPTopOuterMask);
            TextureImage recoloredInner = innerTopResp.recolorWithAnimation(targetTopInner, metaTop);
            Respriter outerTopResp = Respriter.masked((TextureImage)recoloredInner, (TextureImage)BPTopInnerMask);
            if (((Palette)targetTopOuter.getFirst()).size() < 3) {
                ((Palette)targetTopOuter.getFirst()).increaseInner();
            }
            TextureImage recoloredOuter = outerTopResp.recolorWithAnimation(targetTopOuter, metaTop);
            handler.addTextureIfNotPresent(manager, newPath + "_top", () -> recoloredOuter);
            recoloredOuter.close();
        }
        catch (Exception e) {
            handler.getLogger().error("Failed to generate the texture for {} : {}", (Object)block, (Object)e);
        }
    }

    private void createTopTexture(TextureImage original, TextureImage newImage) {
        original.forEachFramePixel((i, x, y) -> {
            int localX = x - original.getFrameStartX(i.intValue());
            int localY = y - original.getFrameStartX(i.intValue());
            if (localX >= 5 && localX <= 10 && localY >= 5 && localY <= 10) {
                newImage.getImage().setPixelRGBA(x - 3, y - 3, original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
            } else if (localX >= 14 && localY > 0 && localY <= 7) {
                newImage.getImage().setPixelRGBA(x - 6, y.intValue(), original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
                newImage.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
            } else if (localY >= 14 && localX > 0 && localX <= 7) {
                newImage.getImage().setPixelRGBA(x.intValue(), y - 6, original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
                newImage.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
            } else if (localX >= 14 && localY >= 14) {
                newImage.getImage().setPixelRGBA(x - 6, y - 6, original.getImage().getPixelRGBA(x.intValue(), y.intValue()));
            } else if (localX >= 10 || localY >= 10) {
                newImage.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
            }
        });
    }

    public class StrippableCutPostBlock
    extends CutPostBlock {
        private final WoodType woodType;

        public StrippableCutPostBlock(WoodType woodType, BlockBehaviour.Properties properties) {
            super(properties);
            this.woodType = woodType;
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)this);
            if (!context.getItemInHand().canPerformAction(itemAbility) || Objects.requireNonNull(location).getPath().contains("stripped")) {
                return null;
            }
            if (itemAbility == ItemAbilities.AXE_STRIP && Objects.nonNull(ValhelsiaStructuresModule.this.cutStrippedPosts.blocks.get(this.woodType))) {
                return (BlockState)((BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(Utils.getID((Block)((Block)ValhelsiaStructuresModule.this.cutStrippedPosts.blocks.get(this.woodType))))).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)ATTACHED, (Comparable)((Boolean)state.getValue((Property)ATTACHED)))).setValue((Property)PARTS, (Comparable)((Integer)state.getValue((Property)PARTS)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            }
            return null;
        }
    }

    public class StrippablePostBlock
    extends PostBlock {
        private final WoodType woodType;

        public StrippablePostBlock(WoodType woodType, BlockBehaviour.Properties properties) {
            super(properties);
            this.woodType = woodType;
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)this);
            if (!context.getItemInHand().canPerformAction(itemAbility) || Objects.requireNonNull(location).getPath().contains("stripped")) {
                return null;
            }
            if (itemAbility == ItemAbilities.AXE_STRIP && Objects.nonNull(ValhelsiaStructuresModule.this.strippedPosts.blocks.get(this.woodType))) {
                return (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(Utils.getID((Block)((Block)ValhelsiaStructuresModule.this.strippedPosts.blocks.get(this.woodType))))).defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)))).setValue((Property)ATTACHED, (Comparable)((Boolean)state.getValue((Property)ATTACHED)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            }
            return null;
        }
    }
}

