/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.attachments.recording;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class RecordingData
implements INBTSerializable<CompoundTag> {
    public static final String RECORDING_TAG = "Recording";
    public static final String REC_POS_TAG = "LooperPos";
    private boolean isRecording = false;
    private BlockPos looperPos = null;

    public void setRecording(BlockPos looperPos) {
        this.isRecording = true;
        this.looperPos = looperPos;
    }

    public void setNotRecording() {
        this.isRecording = false;
        this.looperPos = null;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public BlockPos getLooperPos() {
        return this.looperPos;
    }

    public @UnknownNullability CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean(RECORDING_TAG, this.isRecording);
        if (this.looperPos != null) {
            nbt.put(REC_POS_TAG, NbtUtils.writeBlockPos((BlockPos)this.looperPos));
        }
        return nbt;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        this.isRecording = nbt.getBoolean(RECORDING_TAG);
        this.looperPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)REC_POS_TAG).orElse(null);
    }
}

