/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block;

import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.blockentity.ModBlockEntities;
import com.cstav.evenmoreinstruments.block.util.LooperInteractionRunnableNI;
import com.cstav.evenmoreinstruments.block.util.LooperInteractionRunnableYI;
import com.cstav.evenmoreinstruments.criteria.ModCriteria;
import com.cstav.evenmoreinstruments.criteria.RecordInjectedTrigger;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.item.InstrumentItem;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LooperBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty PLAYING = BooleanProperty.create((String)"playing");
    public static final BooleanProperty RECORD_IN = BooleanProperty.create((String)"record_in");
    public static final BooleanProperty REDSTONE_TRIGGERED = BooleanProperty.create((String)"redstone_triggered");
    public static final BooleanProperty LOOPING = BooleanProperty.create((String)"looping");

    public LooperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PLAYING, (Comparable)Boolean.valueOf(false))).setValue((Property)RECORD_IN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(false))).setValue((Property)LOOPING, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{PLAYING, FACING, RECORD_IN, REDSTONE_TRIGGERED, LOOPING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        boolean hasFootage = ((LooperBlockEntity)((Object)pLevel.getBlockEntity(pPos, (BlockEntityType)ModBlockEntities.LOOPER.get()).orElseThrow())).hasFootage();
        if (hasFootage) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue((Property)RECORD_IN, (Comparable)Boolean.valueOf(true))).setValue((Property)PLAYING, (Comparable)Boolean.valueOf(true)));
        }
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new LooperBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.isClientSide && pBlockEntityType == ModBlockEntities.LOOPER.get() ? (level, pos, state, be) -> ((LooperBlockEntity)be).tick(level, pos, state) : null;
    }

    public static BlockState cyclePlaying(LooperBlockEntity lbe, BlockState state) {
        return lbe.setPlaying((Boolean)state.getValue((Property)PLAYING) == false, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof LooperBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)be;
        return this.performChainedInteractionsYI(List.of(this::insertRecord, this::validateRecordPresence, this::pairInstrumentItem), interaction -> interaction.run(pState, pLevel, pPos, pPlayer, lbe, pStack, pHitResult));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.CONSUME;
        }
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof LooperBlockEntity)) {
            return InteractionResult.FAIL;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)be;
        return this.performChainedInteractionsNI(List.of(this::cycleLooping, this::validateRecordPresence, this::ejectRecord, this::cyclePlaying), interaction -> interaction.run(pState, pLevel, pPos, pPlayer, lbe, pHitResult));
    }

    protected InteractionResult performChainedInteractionsNI(List<LooperInteractionRunnableNI> interactions, Function<LooperInteractionRunnableNI, InteractionResult> performer) {
        return this.performChainedInteractions(interactions, performer, InteractionResult.FAIL, InteractionResult.FAIL);
    }

    protected ItemInteractionResult performChainedInteractionsYI(List<LooperInteractionRunnableYI> interactions, Function<LooperInteractionRunnableYI, ItemInteractionResult> performer) {
        return this.performChainedInteractions(interactions, performer, ItemInteractionResult.FAIL, ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected <R, T> T performChainedInteractions(List<R> interactions, Function<R, T> performer, T fail, T passRes) {
        for (R interaction : interactions) {
            T result = performer.apply(interaction);
            if (result == fail) continue;
            return result;
        }
        return passRes;
    }

    protected InteractionResult cycleLooping(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, BlockHitResult pHitResult) {
        if (pHitResult.getDirection() != this.getLoopDir(pState)) {
            return InteractionResult.FAIL;
        }
        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.cycle((Property)LOOPING));
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult insertRecord(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!(heldStack.getItem() instanceof EMIRecordItem)) {
            return ItemInteractionResult.FAIL;
        }
        if (((Boolean)pState.getValue((Property)RECORD_IN)).booleanValue()) {
            lbe.popRecord();
        }
        lbe.setTheItem(heldStack);
        ((RecordInjectedTrigger)((Object)ModCriteria.RECORD_INJECTED_TRIGGER.get())).trigger((ServerPlayer)pPlayer, heldStack);
        if (!pPlayer.isCreative()) {
            heldStack.shrink(1);
        }
        if (!lbe.hasFootage()) {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"evenmoreinstruments.record.no_footage"), true);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected boolean validateRecordPresence(BlockState pState, Player pPlayer) {
        if (!((Boolean)pState.getValue((Property)RECORD_IN)).booleanValue()) {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"evenmoreinstruments.looper.no_record").withStyle(ChatFormatting.RED), true);
            return true;
        }
        return false;
    }

    protected ItemInteractionResult validateRecordPresence(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        return this.validateRecordPresence(pState, pPlayer) ? ItemInteractionResult.CONSUME_PARTIAL : ItemInteractionResult.FAIL;
    }

    protected InteractionResult validateRecordPresence(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, BlockHitResult pHitResult) {
        return this.validateRecordPresence(pState, pPlayer) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.FAIL;
    }

    protected InteractionResult ejectRecord(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, BlockHitResult pHit) {
        if (!((Boolean)pState.getValue((Property)RECORD_IN)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (pPlayer.isShiftKeyDown() || !lbe.hasFootage()) {
            lbe.popRecord();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected ItemInteractionResult pairInstrumentItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!(heldStack.getItem() instanceof InstrumentItem)) {
            return ItemInteractionResult.FAIL;
        }
        if (lbe.isWritable()) {
            if (LooperUtil.performPair(lbe, () -> LooperUtil.createLooperTag(heldStack, pPos), pPlayer)) {
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"evenmoreinstruments.record.not_writable").withStyle(ChatFormatting.YELLOW), true);
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.FAIL;
    }

    protected InteractionResult cyclePlaying(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, BlockHitResult pHit) {
        if (!lbe.hasFootage()) {
            if (lbe.isWritable()) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"evenmoreinstruments.record.no_footage"), true);
            }
            return InteractionResult.CONSUME_PARTIAL;
        }
        pLevel.setBlockAndUpdate(pPos, (BlockState)LooperBlock.cyclePlaying(lbe, pState).setValue((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(false)));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        if (pLevel.isClientSide()) {
            return pState;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof LooperBlockEntity)) {
            return pState;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)blockEntity;
        lbe.popRecord();
        return pState;
    }

    public Direction getLoopDir(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public Direction getPlayDir(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (pLevel.isClientSide) {
            return;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof LooperBlockEntity)) {
            return;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)blockEntity;
        boolean wasRedstoneTriggered = (Boolean)pState.getValue((Property)REDSTONE_TRIGGERED);
        if (pLevel.hasNeighborSignal(pPos)) {
            if (!wasRedstoneTriggered) {
                lbe.setTicks(0);
                BlockState newState = pState;
                newState = (Boolean)pState.getValue((Property)LOOPING) != false ? LooperBlock.cyclePlaying(lbe, newState) : lbe.setPlaying(true, newState);
                pLevel.setBlockAndUpdate(pPos, (BlockState)newState.setValue((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(true)));
            }
        } else if (wasRedstoneTriggered) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(false)), 1);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.getPlayDir(state).getOpposite() == direction;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return ((Boolean)pState.getValue((Property)PLAYING) != false ? 1 : 0) * 15;
    }

    public boolean triggerEvent(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        switch (pId) {
            case 42: {
                return this.emitNoteParticle(pLevel, pPos, pParam);
            }
        }
        return false;
    }

    protected boolean emitNoteParticle(Level level, BlockPos pos, int noteIndex) {
        level.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)noteIndex / 24.0, 0.0, 0.0);
        return true;
    }
}

