/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block.blockentity;

import com.cstav.evenmoreinstruments.attachments.recording.RecordingCapabilityProvider;
import com.cstav.evenmoreinstruments.block.LooperBlock;
import com.cstav.evenmoreinstruments.block.ModBlocks;
import com.cstav.evenmoreinstruments.block.blockentity.ModBlockEntities;
import com.cstav.evenmoreinstruments.block.util.WritableNoteType;
import com.cstav.evenmoreinstruments.gamerule.ModGameRules;
import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.component.ModDataComponents;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import com.cstav.evenmoreinstruments.item.emirecord.RecordRepository;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperPlayStatePacket;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldNoteSoundPacketUtil;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.networking.packet.instrument.util.NoteSoundPacketUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.sound.registrar.HeldNoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import com.cstav.genshinstrument.util.BiValue;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EventBusSubscriber(modid="evenmoreinstruments")
public class LooperBlockEntity
extends BlockEntity
implements ContainerSingleItem {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String RECORD_TAG = "Record";
    public static final String RECORDING_TAG = "Recording";
    public static final String TICKS_TAG = "Ticks";
    private CompoundTag looperData = new CompoundTag();
    private boolean locked = false;
    private Player lockedBy = null;
    private ItemStack recordIn = ItemStack.EMPTY;
    private CompoundTag channel = new CompoundTag();
    private final InitiatorID looperInitiatorID;
    protected final HashSet<BiValue<HeldNoteSound, NoteSoundMetadata>> cachedHeldNotes = new HashSet();

    protected void stopAndClearHeldSounds() {
        this.notifyHeldNotesPhase(HeldSoundPhase.RELEASE);
        this.cachedHeldNotes.clear();
    }

    public CompoundTag getPersistentData() {
        return this.looperData;
    }

    public CompoundTag getChannel() {
        return this.channel;
    }

    private void setChannel(CompoundTag channel) {
        this.channel = channel;
    }

    private void updateChannel() {
        if (this.recordIn.has((DataComponentType)ModDataComponents.CHANNEL.get())) {
            this.setChannel(((CustomData)this.recordIn.get((DataComponentType)ModDataComponents.CHANNEL.get())).getUnsafe());
        } else if (this.recordIn.has((DataComponentType)ModDataComponents.BURNED_MEDIA.get())) {
            this.setChannel(RecordRepository.getRecord(this.getBurnedMediaLoc()).orElse(null));
        } else {
            this.setChannel(new CompoundTag());
        }
    }

    protected ResourceLocation getBurnedMediaLoc() {
        return (ResourceLocation)this.recordIn.get((DataComponentType)ModDataComponents.BURNED_MEDIA.get());
    }

    private void updateRecordNBT() {
        this.getPersistentData().put(RECORD_TAG, this.recordIn.save((HolderLookup.Provider)this.level.registryAccess()));
    }

    public boolean hasFootage() {
        CompoundTag channel = this.getChannel();
        return channel != null && channel.contains("Notes", 9) && !channel.getList("Notes", 10).isEmpty();
    }

    public boolean isWritable() {
        return this.getChannel().getBoolean("Writable");
    }

    public void setWritable(boolean writable) {
        this.getChannel().putBoolean("Writable", writable);
    }

    public boolean isRecordIn() {
        return !this.recordIn.isEmpty();
    }

    protected CompoundTag getRecordData() {
        return this.channel;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.looperData = pTag.getCompound("ForgeData");
        this.recordIn = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)this.getPersistentData().getCompound(RECORD_TAG));
        this.updateChannel();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("ForgeData", (Tag)this.looperData);
    }

    @NotNull
    public ItemStack getTheItem() {
        return this.recordIn;
    }

    public void setTheItem(ItemStack pStack) {
        Item item = pStack.getItem();
        if (!(item instanceof EMIRecordItem)) {
            return;
        }
        EMIRecordItem recordItem = (EMIRecordItem)item;
        this.recordIn = pStack.copyWithCount(1);
        recordItem.onInsert(this.recordIn, this);
        this.updateChannel();
        BlockState newState = (BlockState)this.getBlockState().setValue((Property)LooperBlock.RECORD_IN, (Comparable)Boolean.valueOf(true));
        if (this.hasFootage()) {
            newState = this.setPlaying(true, newState);
        }
        this.updateRecordNBT();
        this.getLevel().setBlock(this.getBlockPos(), newState, 3);
        this.setChanged();
    }

    public ItemStack splitTheItem(int pAmount) {
        if (!this.isRecordIn() || pAmount <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack prev = this.recordIn;
        this.recordIn = ItemStack.EMPTY;
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.setPlaying(false, this.getBlockState()).setValue((Property)LooperBlock.RECORD_IN, (Comparable)Boolean.valueOf(false)), 3);
        this.getPersistentData().remove(RECORD_TAG);
        this.reset();
        return prev;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(Player pPlayer) {
        return !this.isLocked() || !this.isLockedBy(pPlayer);
    }

    public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        return pStack.getItem() instanceof EMIRecordItem && !this.isRecordIn();
    }

    public boolean canTakeItem(Container pTarget, int pIndex, ItemStack pStack) {
        return !this.isRecordIn();
    }

    public LooperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LOOPER.get(), pPos, pBlockState);
        this.looperInitiatorID = new InitiatorID("block", String.format("x%sy%sz%s", pPos.getX(), pPos.getY(), pPos.getZ()));
        CompoundTag data = this.getPersistentData();
        if (!data.contains(TICKS_TAG, 3)) {
            this.setTicks(0);
        }
    }

    public void setRecording(boolean recording) {
        this.getPersistentData().putBoolean(RECORDING_TAG, recording);
    }

    public void setTicks(int ticks) {
        this.getPersistentData().putInt(TICKS_TAG, ticks);
    }

    public int incrementTick() {
        int ticks = this.getTicks();
        int repTick = this.getRepeatTick();
        ticks = repTick != -1 && ticks > repTick ? this.onLooperEnd() : ++ticks;
        this.setTicks(ticks);
        return ticks;
    }

    public int onLooperEnd() {
        if (!((Boolean)this.getBlockState().getValue((Property)LooperBlock.LOOPING)).booleanValue()) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), this.setPlaying(false, this.getBlockState()));
        }
        this.stopAndClearHeldSounds();
        return 0;
    }

    public void setRepeatTick(int tick) {
        this.getChannel().putInt("RepeatTick", tick);
    }

    public void setLockedBy(Player player) {
        this.lockedBy = player;
    }

    public void lock() {
        this.locked = true;
        this.lockedBy = null;
        this.stopAndClearHeldSounds();
        this.setRepeatTick(this.getTicks());
        this.setRecording(false);
        this.setWritable(false);
        this.setTicks(0);
        this.updateRecordNBT();
        this.setChanged();
    }

    public void reset() {
        this.locked = false;
        this.lockedBy = null;
        this.setTicks(0);
        this.setChanged();
    }

    public boolean isLocked() {
        return this.lockedByAnyone() || this.locked;
    }

    public boolean isRecording() {
        return this.getPersistentData().getBoolean(RECORDING_TAG);
    }

    public boolean isAllowedToRecord(Player player) {
        return !this.lockedByAnyone() || this.isLockedBy(player);
    }

    public boolean lockedByAnyone() {
        return this.lockedBy != null;
    }

    public boolean isLockedBy(Player player) {
        return player.equals((Object)this.lockedBy);
    }

    public int getTicks() {
        return this.getPersistentData().getInt(TICKS_TAG);
    }

    public int getRepeatTick() {
        CompoundTag channel = this.getChannel();
        if (channel.contains("RepeatTick")) {
            return channel.getInt("RepeatTick");
        }
        return -1;
    }

    public BlockState setPlaying(boolean playing, BlockState state) {
        boolean isPlaying = this.hasFootage() && playing;
        BlockState newState = (BlockState)state.setValue((Property)LooperBlock.PLAYING, (Comparable)Boolean.valueOf(isPlaying));
        if (!this.getLevel().isClientSide) {
            this.getLevel().players().forEach(player -> EMIPacketHandler.sendToClient(new LooperPlayStatePacket(isPlaying, this.getBlockPos()), (ServerPlayer)player));
            this.notifyHeldNotesPhase(playing ? HeldSoundPhase.ATTACK : HeldSoundPhase.RELEASE);
        }
        return newState;
    }

    private void notifyHeldNotesPhase(HeldSoundPhase phase) {
        this.cachedHeldNotes.forEach(bi -> HeldNoteSoundPacketUtil.sendPlayNotePackets((Level)this.level, (HeldNoteSound)((HeldNoteSound)bi.obj1()), (NoteSoundMetadata)((NoteSoundMetadata)bi.obj2()), (HeldSoundPhase)phase, (InitiatorID)this.looperInitiatorID));
    }

    public void writeNote(NoteSound sound, NoteSoundMetadata soundMeta, int timestamp) {
        if (!this.isWritable()) {
            return;
        }
        CompoundTag noteTag = this.serializeNoteMeta(soundMeta, timestamp);
        noteTag.putString("NoteType", WritableNoteType.REGULAR.name());
        noteTag.putInt("SoundIndex", sound.index);
        noteTag.putString("SoundType", sound.baseSoundLocation.toString());
        CommonUtil.getOrCreateListTag(this.getChannel(), "Notes").add((Object)noteTag);
        this.setChanged();
    }

    public void writeHeldNote(HeldNoteSound sound, HeldSoundPhase phase, NoteSoundMetadata soundMeta, int timestamp) {
        if (!this.isWritable()) {
            return;
        }
        CompoundTag noteTag = this.serializeNoteMeta(soundMeta, timestamp);
        noteTag.putString("NoteType", WritableNoteType.HELD.name());
        noteTag.putInt("SoundIndex", sound.index());
        noteTag.putString("SoundType", sound.baseSoundLocation().toString());
        noteTag.putString("HeldPhase", phase.name());
        CommonUtil.getOrCreateListTag(this.getChannel(), "Notes").add((Object)noteTag);
        this.setChanged();
    }

    protected CompoundTag serializeNoteMeta(NoteSoundMetadata soundMeta, int timestamp) {
        CompoundTag noteTag = new CompoundTag();
        noteTag.putInt("Pitch", soundMeta.pitch());
        noteTag.putFloat("Volume", (float)soundMeta.volume() / 100.0f);
        noteTag.putInt("Timestamp", timestamp);
        return noteTag;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        LooperBlockEntity lbe = LooperUtil.getFromPos(pLevel, pPos);
        boolean isPlaying = (Boolean)lbe.getBlockState().getValue((Property)LooperBlock.PLAYING);
        if (!isPlaying && !lbe.isRecording()) {
            return;
        }
        if (lbe.isRecording()) {
            lbe.incrementTick();
        }
        if (!isPlaying) {
            return;
        }
        CompoundTag channel = lbe.getChannel();
        if (channel == null) {
            return;
        }
        int ticks = this.getTicks();
        ResourceLocation instrumentId = ResourceLocation.parse((String)channel.getString("InstrumentId"));
        channel.getList("Notes", 10).stream().map(note -> (CompoundTag)note).filter(note -> note.getInt("Timestamp") == ticks).forEach(note -> lbe.playNote((CompoundTag)note, instrumentId));
        lbe.incrementTick();
    }

    private void playNote(CompoundTag note, ResourceLocation instrumentId) {
        try {
            String rawNoteType = note.getString("NoteType");
            WritableNoteType noteType = rawNoteType.isEmpty() ? WritableNoteType.REGULAR : WritableNoteType.valueOf(rawNoteType);
            switch (noteType) {
                case REGULAR: {
                    this.playNoteSound(note, instrumentId);
                    break;
                }
                case HELD: {
                    this.playHeldSound(note, instrumentId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Attempted to play a looper note at {}, but met with an exception", (Object)this.getBlockPos(), (Object)e);
        }
    }

    protected void playNoteSound(CompoundTag noteTag, ResourceLocation instrumentId) {
        NoteSoundMetadata meta = this.metaFromNoteTag(noteTag, instrumentId);
        ResourceLocation soundLocation = ResourceLocation.parse((String)noteTag.getString("SoundType"));
        int soundIndex = noteTag.getInt("SoundIndex");
        NoteSoundPacketUtil.sendPlayNotePackets((Level)this.level, (NoteSound)NoteSoundRegistrar.getSounds((ResourceLocation)soundLocation)[soundIndex], (NoteSoundMetadata)meta);
        this.triggerEmitNoteParticle(meta.pitch());
    }

    protected void playHeldSound(CompoundTag noteTag, ResourceLocation instrumentId) {
        NoteSoundMetadata meta = this.metaFromNoteTag(noteTag, instrumentId);
        ResourceLocation soundLocation = ResourceLocation.parse((String)noteTag.getString("SoundType"));
        int soundIndex = noteTag.getInt("SoundIndex");
        HeldNoteSound sound = HeldNoteSoundRegistrar.getSounds((ResourceLocation)soundLocation)[soundIndex];
        HeldSoundPhase phase = HeldSoundPhase.valueOf((String)noteTag.getString("HeldPhase"));
        HeldNoteSoundPacketUtil.sendPlayNotePackets((Level)this.level, (HeldNoteSound)sound, (NoteSoundMetadata)meta, (HeldSoundPhase)phase, (InitiatorID)this.looperInitiatorID);
        if (phase == HeldSoundPhase.ATTACK) {
            this.cachedHeldNotes.add((BiValue<HeldNoteSound, NoteSoundMetadata>)new BiValue((Object)sound, (Object)meta));
            this.triggerEmitNoteParticle(meta.pitch());
        } else if (phase == HeldSoundPhase.RELEASE) {
            this.cachedHeldNotes.remove(new BiValue((Object)sound, (Object)meta));
        }
    }

    protected NoteSoundMetadata metaFromNoteTag(CompoundTag noteTag, ResourceLocation instrumentId) {
        return new NoteSoundMetadata(this.getBlockPos(), noteTag.getInt("Pitch"), (int)(noteTag.getFloat("Volume") * 100.0f), instrumentId, Optional.empty());
    }

    public void triggerEmitNoteParticle(int pitch) {
        this.getLevel().blockEvent(this.getBlockPos(), (Block)ModBlocks.LOOPER.get(), 42, pitch);
    }

    public void popRecord() {
        if (this.recordIn.is((Item)ModItems.RECORD_WRITABLE.get())) {
            if (this.isWritable()) {
                this.getRecordData().remove("Notes");
            }
            if (!this.hasFootage()) {
                this.recordIn.remove((DataComponentType)ModDataComponents.CHANNEL.get());
            }
        }
        this.stopAndClearHeldSounds();
        Vec3 popVec = Vec3.atLowerCornerWithOffset((Vec3i)this.getBlockPos(), (double)0.5, (double)1.01, (double)0.5).offsetRandom(this.getLevel().random, 0.7f);
        ItemEntity itementity = new ItemEntity(this.getLevel(), popVec.x(), popVec.y(), popVec.z(), this.recordIn);
        itementity.setDefaultPickUpDelay();
        this.getLevel().addFreshEntity((Entity)itementity);
        this.removeItem(0, 1);
    }

    public void setRemoved() {
        super.setRemoved();
        this.stopAndClearHeldSounds();
    }

    public boolean isCapped(Level level) {
        int cap = level.getGameRules().getInt(ModGameRules.RULE_LOOPER_MAX_NOTES);
        return cap >= 0 && this.getChannel().getList("Notes", 10).size() >= cap;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!RecordingCapabilityProvider.isRecording(player)) {
            return;
        }
        player.level().getBlockEntity(RecordingCapabilityProvider.getLooperPos(player), (BlockEntityType)ModBlockEntities.LOOPER.get()).filter(lbe -> lbe.lockedBy.equals((Object)player)).ifPresent(lbe -> {
            lbe.reset();
            lbe.getPersistentData().putBoolean(RECORDING_TAG, false);
        });
        LooperUtil.setNotRecording(player);
    }
}

