/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block.blockentity;

import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="evenmoreinstruments")
public class LooperNoteListener {
    @SubscribeEvent
    public static void onNoteSoundPlayed(NoteSoundPlayedEvent event) {
        LooperNoteListener.getMatchingLooper(event).ifPresent(looperBE -> looperBE.writeNote((NoteSound)event.sound(), event.soundMeta(), looperBE.getTicks()));
    }

    @SubscribeEvent
    public static void onHeldNoteSoundPlayed(HeldNoteSoundPlayedEvent event) {
        LooperNoteListener.getMatchingLooper(event).ifPresent(looperBE -> looperBE.writeHeldNote((HeldNoteSound)event.sound(), event.phase, event.soundMeta(), looperBE.getTicks()));
    }

    private static Optional<LooperBlockEntity> getMatchingLooper(InstrumentPlayedEvent<?> event) {
        if (!event.isByPlayer()) {
            return Optional.empty();
        }
        Player player = (Player)((InstrumentPlayedEvent.EntityInfo)event.entityInfo().get()).entity;
        if (event.level().isClientSide || !LooperUtil.isRecording(player)) {
            return Optional.empty();
        }
        Level level = player.level();
        LooperBlockEntity looperBE = LooperUtil.getFromEvent(event);
        if (looperBE == null || looperBE.isCapped(level)) {
            return Optional.empty();
        }
        if (!looperBE.isWritable()) {
            return Optional.empty();
        }
        if (looperBE.isLocked()) {
            if (!looperBE.isRecording() || !looperBE.isAllowedToRecord(player)) {
                return Optional.empty();
            }
        } else {
            looperBE.setLockedBy(player);
            looperBE.setRecording(true);
            looperBE.getChannel().putString("InstrumentId", event.soundMeta().instrumentId().toString());
        }
        return Optional.of(looperBE);
    }
}

