/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block.partial;

import com.cstav.evenmoreinstruments.block.blockentity.ModInstrumentBlockEntity;
import com.cstav.evenmoreinstruments.block.partial.IDoubleBlock;
import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DoubleInstrumentBlock
extends AbstractInstrumentBlock
implements IDoubleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BlockPart> PART = EnumProperty.create((String)"part", BlockPart.class);

    public DoubleInstrumentBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)BlockPart.LEFT)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InstrumentBlockEntity newBlockEntity(BlockPos arg0, BlockState arg1) {
        return new ModInstrumentBlockEntity(arg0, arg1);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.isClientSide) {
            return;
        }
        BlockPos sidePos = pPos.relative(((Direction)pState.getValue((Property)FACING)).getCounterClockWise());
        pLevel.setBlock(sidePos, (BlockState)pState.setValue(PART, (Comparable)((Object)BlockPart.RIGHT)), 3);
        pLevel.blockUpdated(pPos, Blocks.AIR);
        pLevel.blockUpdated(sidePos, Blocks.AIR);
        pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 3);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (pLevel.isClientSide) {
            return;
        }
        BlockPos sideBlock = this.getOtherBlock(pState, pPos, pLevel);
        if (sideBlock == null) {
            return;
        }
        pLevel.setBlock(sideBlock, Blocks.AIR.defaultBlockState(), 7);
        pLevel.blockUpdated(pPos, Blocks.AIR);
        pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 7);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getHorizontalDirection();
        BlockPos pos = pContext.getClickedPos();
        BlockPos sidePos = pos.relative(direction.getClockWise());
        Level level = pContext.getLevel();
        return level.getBlockState(sidePos).canBeReplaced(pContext) && level.getWorldBorder().isWithinBounds(sidePos) && (level.getBlockState(pos.below(1)).canOcclude() || level.getBlockState(sidePos.below(1)).canOcclude()) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite()) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, PART});
    }

    @Override
    public BlockPos getOtherBlock(BlockState state, BlockPos blockPos, Level level) {
        BlockPos sideBlock = blockPos.relative(state.getValue(PART) == BlockPart.LEFT ? ((Direction)state.getValue((Property)FACING)).getCounterClockWise() : ((Direction)state.getValue((Property)FACING)).getClockWise());
        return !level.getBlockState(sideBlock).is(state.getBlock()) ? null : sideBlock;
    }

    public static enum BlockPart implements StringRepresentable
    {
        LEFT,
        RIGHT;


        public String getSerializedName() {
            return this.toString().toLowerCase();
        }
    }
}

