/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.client.gui.instrument;

import com.cstav.evenmoreinstruments.client.KeyMappings;
import com.cstav.evenmoreinstruments.mixins.required.ScreenAccessor;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.c2s.DoesLooperExistPacket;
import com.cstav.evenmoreinstruments.networking.packet.c2s.LooperRecordStatePacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(modid="evenmoreinstruments", value={Dist.CLIENT})
public class LooperOverlayInjector {
    private static final int REC_BTN_WIDTH = 120;
    private static InstrumentScreen screen = null;
    private static boolean isRecording = false;
    private static Button recordBtn;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof InstrumentScreen)) {
            return;
        }
        InstrumentScreen instrumentScreen = (InstrumentScreen)screen;
        LocalPlayer player = Minecraft.getInstance().player;
        if (InstrumentOpenProvider.isItem((Player)player)) {
            InteractionHand hand = InstrumentOpenProvider.getHand((Player)player);
            ItemStack instrumentItem = player.getItemInHand(hand);
            if (!LooperUtil.hasLooperTag(instrumentItem)) {
                return;
            }
            EMIPacketHandler.sendToServer(new DoesLooperExistPacket(hand));
        } else {
            BlockPos instrumentBlockPos = InstrumentOpenProvider.getBlockPos((Player)player);
            BlockEntity instrumentBE = player.level().getBlockEntity(instrumentBlockPos);
            if (!LooperUtil.hasLooperTag(instrumentBE)) {
                return;
            }
            EMIPacketHandler.sendToServer(new DoesLooperExistPacket());
        }
        LooperOverlayInjector.screen = instrumentScreen;
        recordBtn = Button.builder((Component)LooperOverlayInjector.appendRecordKeyHint(Component.translatable((String)"button.evenmoreinstruments.record")), LooperOverlayInjector::onRecordPress).width(120).pos((instrumentScreen.width - 120) / 2, 5).build();
        event.addListener((GuiEventListener)recordBtn);
    }

    public static void handleLooperRemoved() {
        LooperOverlayInjector.removeRecordButton();
        screen = null;
    }

    private static MutableComponent appendRecordKeyHint(MutableComponent component) {
        return component.append(" (").append(((KeyMapping)KeyMappings.RECORD.get()).getKey().getDisplayName()).append(")");
    }

    @SubscribeEvent
    public static void onKeyboardPress(ScreenEvent.KeyPressed.Pre event) {
        if (((KeyMapping)KeyMappings.RECORD.get()).matches(event.getKeyCode(), event.getScanCode()) && recordBtn != null) {
            recordBtn.playDownSound(Minecraft.getInstance().getSoundManager());
            recordBtn.onPress();
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        if (event.getScreen() != screen) {
            return;
        }
        isRecording = false;
        screen = null;
    }

    private static void onRecordPress(Button btn) {
        InteractionHand hand;
        LocalPlayer player = Minecraft.getInstance().player;
        boolean isItem = InstrumentOpenProvider.isItem((Player)player);
        InteractionHand interactionHand = hand = isItem ? InstrumentOpenProvider.getHand((Player)Minecraft.getInstance().player) : null;
        if (isRecording) {
            LooperOverlayInjector.removeRecordButton();
            screen = null;
        } else {
            btn.setMessage((Component)LooperOverlayInjector.appendRecordKeyHint(Component.translatable((String)"button.evenmoreinstruments.stop")));
        }
        isRecording = !isRecording;
        EMIPacketHandler.sendToServer(new LooperRecordStatePacket(isRecording, hand));
    }

    public static void removeRecordButton() {
        if (screen == null) {
            return;
        }
        ((ScreenAccessor)screen).invokeRemoveWidget((GuiEventListener)recordBtn);
        recordBtn = null;
    }
}

