/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.client.gui.instrument.noteblockinstrument;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.client.gui.instrument.noteblockinstrument.NoteBlockInstrumentMIDIReceiver;
import com.cstav.evenmoreinstruments.client.gui.instrument.noteblockinstrument.NoteBlockInstrumentNote;
import com.cstav.evenmoreinstruments.item.NoteBlockInstrumentItem;
import com.cstav.evenmoreinstruments.sound.ModSounds;
import com.cstav.genshinstrument.client.gui.screen.instrument.floralzither.FloralZitherScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.sound.NoteSound;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NoteBlockInstrumentScreen
extends GridInstrumentScreen {
    public static final String[] NOTES_LAYOUT = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F"};
    public final NoteBlockInstrument instrumentType;
    public final ResourceLocation instrumentId;
    public static final InstrumentThemeLoader THEME_LOADER = InstrumentThemeLoader.fromOther((InstrumentThemeLoader)FloralZitherScreen.THEME_LOADER, (ResourceLocation)EMIMain.loc("note_block_instrument"));

    public NoteBlockInstrumentScreen(NoteBlockInstrument instrumentType) {
        this.instrumentType = instrumentType;
        this.instrumentId = EMIMain.loc(NoteBlockInstrumentItem.getId(instrumentType));
        this.noteGrid.setNoteSounds(ModSounds.getNoteblockSounds(instrumentType));
    }

    public boolean isGenshinInstrument() {
        return false;
    }

    public int rows() {
        return 8;
    }

    public int getNoteSize() {
        return (int)((float)super.getNoteSize() * 0.85f);
    }

    public NoteGridButton createNote(int row, int column, int pitch) {
        return new NoteBlockInstrumentNote(row, column, this, pitch);
    }

    public ResourceLocation getInstrumentId() {
        return this.instrumentId;
    }

    public NoteSound[] getInitSounds() {
        return ModSounds.getNoteblockSounds(NoteBlockInstrument.HARP);
    }

    public String[] noteLayout() {
        return NOTES_LAYOUT;
    }

    public boolean isSSTI() {
        return true;
    }

    public InstrumentMidiReceiver initMidiReceiver() {
        return new NoteBlockInstrumentMIDIReceiver(this);
    }

    public InstrumentThemeLoader getThemeLoader() {
        return THEME_LOADER;
    }
}

