/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item;

import com.cstav.evenmoreinstruments.item.InstrumentAccessoryItem;
import com.cstav.evenmoreinstruments.item.partial.instrument.CreditableInstrumentItem;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.networking.OpenInstrumentPacketSender;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="evenmoreinstruments")
public class AccessoryInstrumentItem
extends CreditableInstrumentItem {
    private final InstrumentAccessoryItem accessory;

    public AccessoryInstrumentItem(OpenInstrumentPacketSender onOpenRequest, InstrumentAccessoryItem accessory, String credit) {
        super(onOpenRequest, credit);
        this.accessory = accessory;
    }

    public AccessoryInstrumentItem(OpenInstrumentPacketSender onOpenRequest, Item.Properties properties, InstrumentAccessoryItem accessory, String credit) {
        super(onOpenRequest, properties, credit);
        this.accessory = accessory;
    }

    public InstrumentAccessoryItem getAccessoryItem() {
        return this.accessory;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack handItem = pPlayer.getItemInHand(pUsedHand);
        if (!pPlayer.getItemInHand(CommonUtil.getOffhand(pUsedHand)).is((Item)this.getAccessoryItem())) {
            if (!pLevel.isClientSide) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"item.evenmoreinstruments.instrument.accessory.not_present", (Object[])new Object[]{this.getAccessoryItem().getName(new ItemStack((ItemLike)this.getAccessoryItem()))}), true);
            }
            return InteractionResultHolder.fail((Object)handItem);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public void onAccessoryUsed(InstrumentPlayedEvent<?> event, ItemStack accessory) {
        if (!accessory.isDamageableItem()) {
            return;
        }
        if (event.level().isClientSide) {
            return;
        }
        if (!event.isByPlayer()) {
            return;
        }
        Player player = (Player)((InstrumentPlayedEvent.EntityInfo)event.entityInfo().get()).entity;
        accessory.hurtAndBreak(this.hurtAccessoryBy(event, accessory), (LivingEntity)player, player.getItemBySlot(EquipmentSlot.MAINHAND).getItem() instanceof AccessoryInstrumentItem ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }

    public int hurtAccessoryBy(InstrumentPlayedEvent<?> event, ItemStack accessory) {
        return 1;
    }

    @SubscribeEvent
    public static void onInstrumentPlayedEvent(InstrumentPlayedEvent<?> event) {
        if (event.level().isClientSide) {
            return;
        }
        if (!event.isByPlayer()) {
            return;
        }
        InstrumentPlayedEvent.EntityInfo entityInfo = (InstrumentPlayedEvent.EntityInfo)event.entityInfo().get();
        Player player = (Player)entityInfo.entity;
        if (!entityInfo.isItemInstrument()) {
            return;
        }
        Item instruemntItem = player.getItemInHand((InteractionHand)entityInfo.hand.get()).getItem();
        if (!(instruemntItem instanceof AccessoryInstrumentItem)) {
            return;
        }
        AccessoryInstrumentItem aiItem = (AccessoryInstrumentItem)instruemntItem;
        ItemStack offhandStack = player.getItemInHand(CommonUtil.getOffhand((InteractionHand)entityInfo.hand.get()));
        if (!(offhandStack.getItem() instanceof InstrumentAccessoryItem)) {
            return;
        }
        if (offhandStack.is((Item)aiItem.getAccessoryItem())) {
            aiItem.onAccessoryUsed(event, offhandStack);
        }
    }
}

