/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.LooperBlock;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.partial.IDoubleBlock;
import com.cstav.evenmoreinstruments.item.component.ModDataComponents;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.s2c.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LooperAdapterItem
extends Item {
    private static final String BLOCK_INSTRUMENT_POS_TAG = "instrument_block";
    private static final String LOOPER_POS_TAG = "looper";

    public LooperAdapterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        boolean pairSucceed;
        if (pContext.getLevel().isClientSide) {
            return InteractionResult.CONSUME_PARTIAL;
        }
        BlockPos pos = pContext.getClickedPos();
        Block block = pContext.getLevel().getBlockState(pContext.getClickedPos()).getBlock();
        ItemStack adapterItem = pContext.getItemInHand();
        Player player = pContext.getPlayer();
        if (block instanceof AbstractInstrumentBlock) {
            pairSucceed = LooperAdapterItem.handleInstrumentBlock(pos, adapterItem, player);
        } else if (block instanceof LooperBlock) {
            pairSucceed = LooperAdapterItem.handleLooperBlock(pos, adapterItem, player);
        } else {
            return InteractionResult.FAIL;
        }
        return pairSucceed ? InteractionResult.SUCCESS : InteractionResult.CONSUME_PARTIAL;
    }

    private static boolean handleInstrumentBlock(BlockPos blockPos, ItemStack adapterItem, Player player) {
        if (adapterItem.has((DataComponentType)ModDataComponents.LOOPER_POS.get())) {
            return LooperAdapterItem.pairLooperToInstrument(adapterItem, (BlockPos)adapterItem.get((DataComponentType)ModDataComponents.LOOPER_POS.get()), blockPos, player);
        }
        adapterItem.set((DataComponentType)ModDataComponents.BLOCK_INSTRUMENT_POS.get(), (Object)blockPos);
        player.displayClientMessage((Component)Component.translatable((String)"item.evenmoreinstruments.looper_adapter.looper.select"), true);
        return true;
    }

    private static boolean handleLooperBlock(BlockPos blockPos, ItemStack adapterItem, Player player) {
        BlockEntity be = player.level().getBlockEntity(blockPos);
        if (!(be instanceof LooperBlockEntity)) {
            return false;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)be;
        if (!lbe.isRecordIn()) {
            player.displayClientMessage((Component)Component.translatable((String)"evenmoreinstruments.looper.no_record").withStyle(ChatFormatting.RED), true);
            return false;
        }
        if (adapterItem.has((DataComponentType)ModDataComponents.BLOCK_INSTRUMENT_POS.get())) {
            return LooperAdapterItem.pairLooperToInstrument(adapterItem, blockPos, (BlockPos)adapterItem.get((DataComponentType)ModDataComponents.BLOCK_INSTRUMENT_POS.get()), player);
        }
        if (adapterItem.has((DataComponentType)ModDataComponents.LOOPER_POS.get())) {
            return LooperAdapterItem.syncLoopers(adapterItem, (BlockPos)adapterItem.get((DataComponentType)ModDataComponents.LOOPER_POS.get()), blockPos, player);
        }
        adapterItem.set((DataComponentType)ModDataComponents.LOOPER_POS.get(), (Object)blockPos);
        player.displayClientMessage((Component)Component.translatable((String)"item.evenmoreinstruments.looper_adapter.instrument.select").withStyle(ChatFormatting.GREEN), true);
        return true;
    }

    private static boolean pairLooperToInstrument(ItemStack adapterItem, InstrumentBlockEntity ibe, LooperBlockEntity lbe, Player player) {
        LooperAdapterItem.clearComponents(adapterItem);
        return LooperUtil.performPair(lbe, () -> {
            BlockState instrumentBlockState = ibe.getBlockState();
            Block instrumentBlock = instrumentBlockState.getBlock();
            BlockPos instrumentBlockPos = ibe.getBlockPos();
            BlockPos looperBlockPos = lbe.getBlockPos();
            BlockPos otherBlockPos = null;
            if (instrumentBlock instanceof IDoubleBlock) {
                IDoubleBlock doubleBlock = (IDoubleBlock)instrumentBlock;
                otherBlockPos = doubleBlock.getOtherBlock(instrumentBlockState, instrumentBlockPos, player.level());
            }
            LooperUtil.createLooperTag((BlockEntity)ibe, looperBlockPos);
            if (otherBlockPos != null) {
                LooperUtil.createLooperTag(player.level().getBlockEntity(otherBlockPos), looperBlockPos);
            }
            ibe.setChanged();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag((BlockEntity)ibe), instrumentBlockPos), serverPlayer);
                if (otherBlockPos != null) {
                    EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag((BlockEntity)ibe), otherBlockPos), serverPlayer);
                }
            }
        }, player);
    }

    private static boolean pairLooperToInstrument(ItemStack adapterItem, BlockPos looperPos, BlockPos instrumentPos, Player player) {
        Level level = player.level();
        BlockEntity lbe = level.getBlockEntity(looperPos);
        BlockEntity ibe = level.getBlockEntity(instrumentPos);
        if (!(lbe instanceof LooperBlockEntity) || !(ibe instanceof InstrumentBlockEntity)) {
            return false;
        }
        return LooperAdapterItem.pairLooperToInstrument(adapterItem, (InstrumentBlockEntity)ibe, (LooperBlockEntity)lbe, player);
    }

    private static boolean syncLoopers(ItemStack adapterItem, LooperBlockEntity lbe1, LooperBlockEntity lbe2, Player player) {
        if (lbe1.getBlockPos().equals((Object)lbe2.getBlockPos())) {
            return false;
        }
        LooperAdapterItem.clearComponents(adapterItem);
        if (!lbe1.hasFootage() || !lbe1.hasFootage()) {
            player.displayClientMessage((Component)Component.translatable((String)"evenmoreinstruments.record.no_footage").withStyle(ChatFormatting.RED), true);
            return true;
        }
        lbe2.setRepeatTick(lbe1.getRepeatTick());
        lbe2.setTicks(lbe1.getTicks());
        player.displayClientMessage((Component)Component.translatable((String)"item.evenmoreinstruments.looper_adapter.instrument.success_pair").withStyle(ChatFormatting.GREEN), true);
        return true;
    }

    private static boolean syncLoopers(ItemStack adapterItem, BlockPos looper1Pos, BlockPos looper2Pos, Player player) {
        if (looper2Pos.equals((Object)looper1Pos)) {
            return false;
        }
        Level level = player.level();
        BlockEntity lbe1 = level.getBlockEntity(looper1Pos);
        BlockEntity lbe2 = level.getBlockEntity(looper2Pos);
        if (!(lbe1 instanceof LooperBlockEntity) || !(lbe2 instanceof LooperBlockEntity)) {
            return false;
        }
        return LooperAdapterItem.syncLoopers(adapterItem, (LooperBlockEntity)lbe1, (LooperBlockEntity)lbe2, player);
    }

    public static void clearComponents(ItemStack adapterItem) {
        adapterItem.remove((DataComponentType)ModDataComponents.LOOPER_POS.get());
        adapterItem.remove((DataComponentType)ModDataComponents.BLOCK_INSTRUMENT_POS.get());
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> tooltipComponents, TooltipFlag pTooltipFlag) {
        if (!Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.shift.hint.show").withStyle(ChatFormatting.YELLOW));
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"item.shift.hint.hide").withStyle(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.translatable((String)"item.evenmoreinstruments.looper_adapter.instrument.description").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.evenmoreinstruments.looper_adapter.looper.description").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(pStack, pContext, tooltipComponents, pTooltipFlag);
    }
}

