/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.EMIModCreativeModeTabs;
import com.cstav.evenmoreinstruments.block.ModBlocks;
import com.cstav.evenmoreinstruments.item.AccessoryInstrumentItem;
import com.cstav.evenmoreinstruments.item.InstrumentAccessoryItem;
import com.cstav.evenmoreinstruments.item.KeyboardBlockItem;
import com.cstav.evenmoreinstruments.item.LooperAdapterItem;
import com.cstav.evenmoreinstruments.item.NoteBlockInstrumentItem;
import com.cstav.evenmoreinstruments.item.ViolinItem;
import com.cstav.evenmoreinstruments.item.emirecord.BurnedRecordItem;
import com.cstav.evenmoreinstruments.item.emirecord.WritableRecordItem;
import com.cstav.evenmoreinstruments.item.partial.instrument.CreditableBlockInstrumentItem;
import com.cstav.evenmoreinstruments.item.partial.instrument.CreditableInstrumentItem;
import com.cstav.evenmoreinstruments.item.partial.instrument.CreditableWindInstrumentItem;
import com.cstav.genshinstrument.GICreativeModeTabs;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="evenmoreinstruments", value={Dist.CLIENT})
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"evenmoreinstruments");
    private static final LinkedHashMap<ResourceKey<CreativeModeTab>, ArrayList<DeferredHolder<Item, Item>>> CREATIVE_TABS_MAP = new LinkedHashMap();
    private static final ResourceKey<CreativeModeTab>[] DEFAULT_INSTRUMENTS_TABS = new ResourceKey[]{GICreativeModeTabs.INSTRUMENTS_TAB.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES};
    private static final ResourceKey<CreativeModeTab>[] DEFAULT_INSTRUMENT_BLOCK_TABS = new ResourceKey[]{GICreativeModeTabs.INSTRUMENTS_TAB.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES, CreativeModeTabs.FUNCTIONAL_BLOCKS};
    public static final DeferredHolder<Item, Item> VIOLIN_BOW = ModItems.register("violin_bow", () -> new InstrumentAccessoryItem(new Item.Properties().stacksTo(1).durability(2048)));
    public static final DeferredHolder<Item, Item> VIOLIN = ModItems.register("violin", ViolinItem::new, DEFAULT_INSTRUMENTS_TABS, VIOLIN_BOW);
    public static final DeferredHolder<Item, Item> GUITAR = ModItems.register("guitar", () -> new CreditableInstrumentItem(player -> InstrumentPacketUtil.sendOpenPacket((ServerPlayer)player, (ResourceLocation)ModItems.loc("guitar")), "Philharmonia"));
    public static final DeferredHolder<Item, Item> PIPA = ModItems.register("pipa", () -> new CreditableInstrumentItem(player -> InstrumentPacketUtil.sendOpenPacket((ServerPlayer)player, (ResourceLocation)ModItems.loc("pipa")), "DSK Asian DreamZ"));
    public static final DeferredHolder<Item, Item> BACHI = ModItems.register("bachi", () -> new InstrumentAccessoryItem(new Item.Properties().stacksTo(1).durability(2048)));
    public static final DeferredHolder<Item, Item> SHAMISEN = ModItems.register("shamisen", () -> new AccessoryInstrumentItem(player -> InstrumentPacketUtil.sendOpenPacket((ServerPlayer)player, (ResourceLocation)ModItems.loc("shamisen")), (InstrumentAccessoryItem)((Object)((Object)BACHI.get())), "Roland SC-88"), DEFAULT_INSTRUMENTS_TABS, BACHI);
    public static final DeferredHolder<Item, Item> KOTO = ModItems.register("koto", () -> new CreditableBlockInstrumentItem((Block)ModBlocks.KOTO.get(), new Item.Properties().stacksTo(1), "DSK Asian DreamZ"), DEFAULT_INSTRUMENT_BLOCK_TABS);
    public static final DeferredHolder<Item, Item> TROMBONE = ModItems.register("trombone", () -> new CreditableWindInstrumentItem(player -> InstrumentPacketUtil.sendOpenPacket((ServerPlayer)player, (ResourceLocation)ModItems.loc("trombone")), "Philharmonia"));
    public static final DeferredHolder<Item, Item> SAXOPHONE = ModItems.register("saxophone", () -> new CreditableWindInstrumentItem(player -> InstrumentPacketUtil.sendOpenPacket((ServerPlayer)player, (ResourceLocation)ModItems.loc("saxophone")), "Philharmonia"));
    public static final DeferredHolder<Item, Item> KEYBOARD = ModItems.register("keyboard", () -> new KeyboardBlockItem((Block)ModBlocks.KEYBOARD.get(), new Item.Properties().stacksTo(1), null), DEFAULT_INSTRUMENT_BLOCK_TABS);
    public static final DeferredHolder<Item, Item> KEYBOARD_STAND = ModItems.registerBlockItem(ModBlocks.KEYBOARD_STAND, GICreativeModeTabs.INSTRUMENTS_TAB.getKey());
    public static final DeferredHolder<Item, Item> LOOPER = ModItems.registerBlockItem(ModBlocks.LOOPER, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey(), CreativeModeTabs.FUNCTIONAL_BLOCKS, CreativeModeTabs.REDSTONE_BLOCKS);
    public static final DeferredHolder<Item, Item> LOOPER_ADAPTER = ModItems.register("looper_adapter", () -> new LooperAdapterItem(new Item.Properties().stacksTo(1)), CreativeModeTabs.REDSTONE_BLOCKS, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final DeferredHolder<Item, Item> RECORD_WRITABLE = ModItems.register("record_writable", () -> new WritableRecordItem(new Item.Properties().stacksTo(16)), CreativeModeTabs.TOOLS_AND_UTILITIES, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final DeferredHolder<Item, Item> RECORD_JOHNNY = ModItems.register("record_johnny", () -> new BurnedRecordItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE), EMIMain.loc("johnny"), "H\u00e4nschen klein - Franz Wiedemann", null), CreativeModeTabs.TOOLS_AND_UTILITIES, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final DeferredHolder<Item, Item> RECORD_SUPER_IDOL = ModItems.register("record_super_idol", () -> new BurnedRecordItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE), EMIMain.loc("super_idol"), "Super Idol - De Xian Rong", "Saxophy"), CreativeModeTabs.TOOLS_AND_UTILITIES, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final DeferredHolder<Item, Item> RECORD_OVEN_KID = ModItems.register("record_oven_kid", () -> new BurnedRecordItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE), EMIMain.loc("oven_kid"), "Timmy Trumpet & Savage - Freaks", "StavWasPlayZ"), CreativeModeTabs.TOOLS_AND_UTILITIES, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final DeferredHolder<Item, Item> RECORD_SAD_VIOLIN = ModItems.register("record_sad_violin", () -> new BurnedRecordItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE), EMIMain.loc("sad_violin"), "Sad Romance - Ji Pyeongkeyon", "StavWasPlayZ"), CreativeModeTabs.TOOLS_AND_UTILITIES, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final DeferredHolder<Item, Item> RECORD_RICKROLL = ModItems.register("record_rickroll", () -> new BurnedRecordItem(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC), EMIMain.loc("rickroll"), null, "StavWasPlayZ", (Component)Component.translatable((String)"item.evenmoreinstruments.interesting_record")), CreativeModeTabs.TOOLS_AND_UTILITIES, EMIModCreativeModeTabs.MUSIC_PRODUCTION_TAB.getKey());
    public static final Map<NoteBlockInstrument, DeferredHolder<Item, Item>> NOTEBLOCK_INSTRUMENTS = ModItems.initNoteBlockInstruments();

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
    }

    private static ArrayList<DeferredHolder<Item, Item>> getCreativeItems(ResourceKey<CreativeModeTab> tabKey) {
        if (!CREATIVE_TABS_MAP.containsKey(tabKey)) {
            CREATIVE_TABS_MAP.put(tabKey, new ArrayList());
        }
        return CREATIVE_TABS_MAP.get(tabKey);
    }

    public static HashMap<NoteBlockInstrument, DeferredHolder<Item, Item>> initNoteBlockInstruments() {
        NoteBlockInstrument[] instruments = NoteBlockInstrument.values();
        HashMap<NoteBlockInstrument, DeferredHolder<Item, Item>> result = new HashMap<NoteBlockInstrument, DeferredHolder<Item, Item>>(instruments.length);
        for (NoteBlockInstrument instrument : instruments) {
            if (!instrument.isTunable()) continue;
            result.put(instrument, ModItems.register(NoteBlockInstrumentItem.getId(instrument), () -> new NoteBlockInstrumentItem(instrument)));
        }
        return result;
    }

    private static ResourceLocation loc(String path) {
        return EMIMain.loc(path);
    }

    @SafeVarargs
    private static DeferredHolder<Item, Item> registerBlockItem(DeferredHolder<Block, Block> block, ResourceKey<CreativeModeTab> ... tabs) {
        return ModItems.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()), tabs);
    }

    private static DeferredHolder<Item, Item> register(String name, Supplier<Item> supplier, ResourceKey<CreativeModeTab>[] tabs, DeferredHolder<Item, Item> appearsBefore) {
        DeferredHolder item = ITEMS.register(name, supplier);
        for (ResourceKey<CreativeModeTab> tabKey : tabs) {
            ArrayList<DeferredHolder<Item, Item>> items = ModItems.getCreativeItems(tabKey);
            if (items.contains(appearsBefore)) {
                items.add(items.indexOf(appearsBefore), (DeferredHolder<Item, Item>)item);
                continue;
            }
            items.add((DeferredHolder<Item, Item>)item);
        }
        return item;
    }

    @SafeVarargs
    private static DeferredHolder<Item, Item> register(String name, Supplier<Item> supplier, ResourceKey<CreativeModeTab> ... tabs) {
        DeferredHolder item = ITEMS.register(name, supplier);
        for (ResourceKey<CreativeModeTab> tabKey : tabs) {
            ModItems.getCreativeItems(tabKey).add((DeferredHolder<Item, Item>)item);
        }
        return item;
    }

    private static DeferredHolder<Item, Item> register(String name, Supplier<Item> supplier) {
        return ModItems.register(name, supplier, DEFAULT_INSTRUMENTS_TABS);
    }

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        CREATIVE_TABS_MAP.keySet().forEach(tabKey -> {
            if (!event.getTabKey().equals(tabKey)) {
                return;
            }
            event.acceptAll(ModItems.getCreativeItems((ResourceKey<CreativeModeTab>)tabKey).stream().map(item -> new ItemStack((ItemLike)item.get())).toList());
        });
    }
}

