/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item.crafting;

import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.crafting.ModRecipeSerializers;
import com.cstav.evenmoreinstruments.item.emirecord.WritableRecordItem;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RecordCloningRecipe
extends CustomRecipe {
    public RecordCloningRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput pInput, Level pLevel) {
        return this.getIngredientsFromContainer(pInput).isPresent();
    }

    private static boolean isWritableRecord(ItemStack stack) {
        return stack.is((Item)ModItems.RECORD_WRITABLE.get()) && !((WritableRecordItem)stack.getItem()).isBurned(stack);
    }

    private static boolean isBurnedRecord(ItemStack stack) {
        return stack.is((Item)ModItems.RECORD_WRITABLE.get()) && ((WritableRecordItem)stack.getItem()).isBurned(stack);
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        Optional<ItemStack[]> ingredients = this.getIngredientsFromContainer(pContainer);
        if (ingredients.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ingredients.get()[1].copyWithCount(1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput pInput) {
        NonNullList result = NonNullList.withSize((int)pInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < result.size(); ++i) {
            ItemStack stack = pInput.getItem(i);
            if (!RecordCloningRecipe.isBurnedRecord(stack)) continue;
            result.set(i, (Object)stack.copyWithCount(1));
            return result;
        }
        return result;
    }

    private Optional<ItemStack[]> getIngredientsFromContainer(CraftingInput pInv) {
        ItemStack burnedRecord = ItemStack.EMPTY;
        ItemStack writableRecord = ItemStack.EMPTY;
        for (int i = 0; i < pInv.size(); ++i) {
            ItemStack stack = pInv.getItem(i);
            if (stack.isEmpty()) continue;
            if (RecordCloningRecipe.isBurnedRecord(stack)) {
                if (!burnedRecord.isEmpty()) {
                    return Optional.empty();
                }
                burnedRecord = stack;
                if (writableRecord.isEmpty()) continue;
                return Optional.of(new ItemStack[]{writableRecord, burnedRecord});
            }
            if (!RecordCloningRecipe.isWritableRecord(stack) || !writableRecord.isEmpty()) {
                return Optional.empty();
            }
            writableRecord = stack;
            if (burnedRecord.isEmpty()) continue;
            return Optional.of(new ItemStack[]{writableRecord, burnedRecord});
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.RECORD_CLONING.get();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }
}

