/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item.emirecord;

import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.item.component.ModDataComponents;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class BurnedRecordItem
extends EMIRecordItem {
    private final ResourceLocation burnedMedia;
    private final Component title;
    @Nullable
    private final String info;
    @Nullable
    private final String arranger;

    public BurnedRecordItem(Item.Properties properties, ResourceLocation burnedMedia, @Nullable String info, @Nullable String arranger, Component title) {
        super(properties);
        this.burnedMedia = burnedMedia;
        this.info = info;
        this.arranger = arranger;
        this.title = title;
    }

    public BurnedRecordItem(Item.Properties properties, ResourceLocation burnedMedia, @Nullable String info, @Nullable String arranger) {
        this(properties, burnedMedia, info, arranger, (Component)Component.translatable((String)"item.evenmoreinstruments.burned_record"));
    }

    @Override
    public void onInsert(ItemStack stack, LooperBlockEntity lbe) {
        stack.set((DataComponentType)ModDataComponents.BURNED_MEDIA.get(), (Object)this.burnedMedia);
    }

    public Component getName(ItemStack pStack) {
        return this.title;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (this.info != null) {
            pTooltipComponents.add((Component)Component.literal((String)this.info).withStyle(ChatFormatting.GRAY));
        }
        if (this.arranger != null) {
            pTooltipComponents.add((Component)Component.translatable((String)"item.evenmoreinstruments.record.arranger", (Object[])new Object[]{this.arranger}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

