/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item.emirecord;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@EventBusSubscriber(modid="evenmoreinstruments")
public class RecordRepository {
    private static final ConcurrentHashMap<ResourceLocation, CompoundTag> RECORDS = new ConcurrentHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String RECORDS_DIR = "records";
    private static final String DATA_DIR = "evenmoreinstruments/records";
    private static final Gson GSON = new Gson();

    public static Optional<CompoundTag> getRecord(ResourceLocation loc) {
        return RECORDS.containsKey(loc) ? Optional.of(RECORDS.get(loc).copy()) : RecordRepository.tryGetRecordFromGen(loc);
    }

    public static Set<ResourceLocation> getRecords() {
        return Collections.unmodifiableSet(RECORDS.keySet());
    }

    private static Optional<CompoundTag> tryGetRecordFromGen(ResourceLocation loc) {
        try {
            Path file = RecordRepository.getRecordPath(loc, true);
            try (BufferedReader reader = Files.newBufferedReader(file);){
                RecordRepository.loadRecord(loc, JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                return Optional.empty();
            }
            return Optional.of(RECORDS.get(loc).copy());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @SubscribeEvent
    public static void registerReloadEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(GSON, DATA_DIR){

            protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                RecordRepository.reloadRecords(pObject);
            }
        });
    }

    private static void reloadRecords(Map<ResourceLocation, JsonElement> pObject) {
        RECORDS.clear();
        pObject.forEach((loc, tag) -> RecordRepository.loadRecord(loc, (JsonElement)pObject.get(loc)));
    }

    private static void loadRecord(ResourceLocation loc, JsonElement channelObj) {
        RECORDS.put(loc, (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.INSTANCE, channelObj));
        LOGGER.info("Successfully loaded burned record {}", (Object)loc);
    }

    public static Stream<ResourceLocation> listRecords(boolean includeBuiltIn) {
        try {
            return Streams.concat((Stream[])new Stream[]{RecordRepository.getRecords().stream().filter(loc -> !loc.getNamespace().equals("evenmoreinstruments") || includeBuiltIn), Files.list(RecordRepository.getGenPath()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(RecordRepository::listGeneratedInNamespace)}).distinct();
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static void saveRecord(ResourceLocation name, CompoundTag channel) throws IOException {
        Path path = RecordRepository.getRecordPath(name, false);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (FileWriter outStream = new FileWriter(path.toFile());){
            JsonElement jsonData = (JsonElement)NbtOps.INSTANCE.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)channel);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(jsonData, (Appendable)outStream);
        }
        RECORDS.put(name, channel);
    }

    public static void removeRecord(ResourceLocation name) throws IOException {
        Path path = RecordRepository.getRecordPath(name, true);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new ResourceLocationException("Could not find resource " + String.valueOf(name));
        }
        Files.delete(path);
        RECORDS.remove(name);
    }

    private static Path getGenPath(boolean failIfNone) throws IOException {
        Path path = ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.GENERATED_DIR).normalize();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            if (failIfNone) {
                throw new IOException("Directory not found: " + String.valueOf(path));
            }
        } else {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    private static Path getGenPath() throws IOException {
        return RecordRepository.getGenPath(false);
    }

    private static Path getRecordPath(ResourceLocation name, boolean failIfNone) throws IOException {
        Path genPath = RecordRepository.getGenPath(failIfNone).resolve(name.getNamespace()).resolve("evenmoreinstruments").resolve(RECORDS_DIR);
        Path path = FileUtil.createPathToResource((Path)genPath, (String)name.getPath(), (String)".json");
        if (!(path.startsWith(genPath) && FileUtil.isPathNormalized((Path)path) && FileUtil.isPathPortable((Path)path))) {
            throw new ResourceLocationException("Invalid resource path: " + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0]) && failIfNone) {
            throw new ResourceLocationException("Could not find resource " + String.valueOf(name));
        }
        return path;
    }

    private static Stream<ResourceLocation> listGeneratedInNamespace(Path pPath) {
        Path path = pPath.resolve("evenmoreinstruments").resolve(RECORDS_DIR);
        return RecordRepository.listFolderContents(path, pPath.getFileName().toString(), ".json");
    }

    private static Stream<ResourceLocation> listFolderContents(Path pFolder, String pNamespace, String pPath) {
        if (!Files.isDirectory(pFolder, new LinkOption[0])) {
            return Stream.empty();
        }
        int i = pPath.length();
        Function<String, String> function = p_230358_ -> p_230358_.substring(0, p_230358_.length() - i);
        try {
            return Files.walk(pFolder, new FileVisitOption[0]).filter(p_230381_ -> p_230381_.toString().endsWith(pPath)).mapMulti((p_230386_, p_230387_) -> {
                try {
                    p_230387_.accept(ResourceLocation.fromNamespaceAndPath((String)pNamespace, (String)((String)function.apply(RecordRepository.relativize(pFolder, p_230386_)))));
                }
                catch (ResourceLocationException resourcelocationexception) {
                    LOGGER.error("Invalid location while listing pack contents", (Throwable)resourcelocationexception);
                }
            });
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to list folder contents", (Throwable)ioexception);
            return Stream.empty();
        }
    }

    private static String relativize(Path pRoot, Path pPath) {
        return pRoot.relativize(pPath).toString().replace(File.separator, "/");
    }
}

