/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item.emirecord;

import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.item.component.ModDataComponents;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class WritableRecordItem
extends EMIRecordItem {
    public WritableRecordItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBurned(ItemStack stack) {
        return stack.has((DataComponentType)ModDataComponents.CHANNEL.get()) && !((CustomData)stack.get((DataComponentType)ModDataComponents.CHANNEL.get())).getUnsafe().getBoolean("Writable") || stack.has((DataComponentType)ModDataComponents.BURNED_MEDIA.get());
    }

    public boolean isFoil(ItemStack pStack) {
        return this.isBurned(pStack);
    }

    @Override
    public void onInsert(ItemStack stack, LooperBlockEntity lbe) {
        CompoundTag channel;
        if (stack.has((DataComponentType)ModDataComponents.BURNED_MEDIA.get())) {
            return;
        }
        CustomData channelRaw = (CustomData)stack.get((DataComponentType)ModDataComponents.CHANNEL.get());
        if (channelRaw == null) {
            channel = new CompoundTag();
            channel.putBoolean("Writable", true);
        } else {
            channel = channelRaw.getUnsafe();
            if (!channel.getBoolean("Writable") && !channel.contains("Notes", 9)) {
                channel = LooperUtil.migrateLegacyLooper(lbe).orElse(channel);
            }
        }
        stack.set((DataComponentType)ModDataComponents.CHANNEL.get(), (Object)CustomData.of((CompoundTag)channel));
    }

    public Component getName(ItemStack pStack) {
        return Component.translatable((String)String.format("item.evenmoreinstruments.%s_record", this.isBurned(pStack) ? "burned" : "writable"));
    }
}

