/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.loot;

import com.cstav.evenmoreinstruments.item.ModItems;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber(modid="evenmoreinstruments")
public class ModLootTables {
    private static final float RECORD_DROP_PROBABILITY = 0.056f;
    private static final Map<ResourceLocation, Supplier<LootPool>> TO_INJECT = Map.of(BuiltInLootTables.JUNGLE_TEMPLE.location(), () -> ModLootTables.createRecordPool((Item)ModItems.RECORD_SUPER_IDOL.get()), BuiltInLootTables.VILLAGE_SAVANNA_HOUSE.location(), () -> ModLootTables.createRecordPool((Item)ModItems.RECORD_SAD_VIOLIN.get()), BuiltInLootTables.BASTION_OTHER.location(), () -> ModLootTables.createRecordPool((Item)ModItems.RECORD_OVEN_KID.get()), BuiltInLootTables.ABANDONED_MINESHAFT.location(), () -> ModLootTables.createRecordPool((Item)ModItems.RECORD_RICKROLL.get()), BuiltInLootTables.BURIED_TREASURE.location(), () -> ModLootTables.createRecordPool((Item)ModItems.RECORD_JOHNNY.get()));

    private static LootPool createRecordPool(Item item) {
        return LootPool.lootPool().name("emi_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath()).add(LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)0.056f))).build();
    }

    @SubscribeEvent
    public static void onLootTablesLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        if (!TO_INJECT.containsKey(id)) {
            return;
        }
        event.getTable().addPool(TO_INJECT.get(id).get());
    }
}

