/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.mixins.optional;

import com.cstav.evenmoreinstruments.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Parrot.class})
public abstract class ParrotLooperDanceInjector
extends Entity {
    @Shadow
    private BlockPos jukebox;
    @Shadow
    private boolean partyParrot;
    @Unique
    private boolean isLooper;
    @Unique
    private BlockPos jukeboxBefore;
    @Unique
    private boolean partiedBefore;

    public ParrotLooperDanceInjector(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep()V"})
    private void aiStepHead(CallbackInfo info) {
        this.jukeboxBefore = this.jukebox;
        this.isLooper = this.jukebox != null && this.level().getBlockState(this.jukebox).is((Block)ModBlocks.LOOPER.get());
        this.partiedBefore = this.partyParrot;
    }

    @Inject(at={@At(value="TAIL")}, method={"aiStep()V"})
    private void aiStepTail(CallbackInfo info) {
        if (!this.isLooper) {
            return;
        }
        if (!this.partiedBefore) {
            this.jukebox = null;
        } else if (this.jukeboxBefore.closerToCenterThan((Position)this.position(), 3.46)) {
            this.partyParrot = true;
            this.jukebox = this.jukeboxBefore;
        }
    }
}

