/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking;

import com.cstav.evenmoreinstruments.attachments.ModAttachments;
import com.cstav.evenmoreinstruments.attachments.ModTagAttachment;
import com.cstav.evenmoreinstruments.client.gui.instrument.LooperOverlayInjector;
import com.cstav.evenmoreinstruments.client.gui.instrument.noteblockinstrument.NoteBlockInstrumentScreen;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperPlayStatePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.OpenNoteBlockInstrumentPacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.SyncModTagPacket;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.util.ServerUtil;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@OnlyIn(value=Dist.CLIENT)
public class ClientDistExecutor {
    public static final Map<String, BiConsumer<? extends IModPacket, IPayloadContext>> PACKET_SWITCH = Map.ofEntries(ServerUtil.switchEntry(ClientDistExecutor::handle, LooperPlayStatePacket.class), ServerUtil.switchEntry(ClientDistExecutor::handle, LooperUnplayablePacket.class), ServerUtil.switchEntry(ClientDistExecutor::handle, OpenNoteBlockInstrumentPacket.class), ServerUtil.switchEntry(ClientDistExecutor::handle, SyncModTagPacket.class));

    private static void handle(LooperPlayStatePacket packet, IPayloadContext context) {
        Level level = Minecraft.getInstance().player.level();
        List closeEntities = level.getEntitiesOfClass(LivingEntity.class, new AABB(packet.blockPos).inflate(3.0));
        for (LivingEntity livingentity : closeEntities) {
            livingentity.setRecordPlayingNearby(packet.blockPos, packet.isPlaying);
        }
    }

    private static void handle(LooperUnplayablePacket packet, IPayloadContext context) {
        LooperOverlayInjector.handleLooperRemoved();
    }

    private static void handle(OpenNoteBlockInstrumentPacket packet, IPayloadContext context) {
        Minecraft.getInstance().setScreen((Screen)new NoteBlockInstrumentScreen(packet.instrument));
    }

    private static void handle(SyncModTagPacket packet, IPayloadContext context) {
        Level level = Minecraft.getInstance().player.level();
        BlockEntity be = level.getBlockEntity(packet.pos);
        if (be == null) {
            return;
        }
        ModTagAttachment tag = new ModTagAttachment();
        tag.setTag(packet.modTag);
        be.setData(ModAttachments.MOD_TAG, (Object)tag);
    }
}

