/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking;

import com.cstav.evenmoreinstruments.networking.ClientDistExecutor;
import com.cstav.evenmoreinstruments.networking.packet.c2s.DoesLooperExistPacket;
import com.cstav.evenmoreinstruments.networking.packet.c2s.LooperRecordStatePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperPlayStatePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.OpenNoteBlockInstrumentPacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.SyncModTagPacket;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.util.ServerUtil;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="evenmoreinstruments")
public class EMIPacketHandler {
    private static final List<Class<IModPacket>> ACCEPTABLE_PACKETS_C2S = List.of(new Class[]{DoesLooperExistPacket.class, LooperRecordStatePacket.class});
    private static final List<Class<IModPacket>> ACCEPTABLE_PACKETS_S2C = List.of(new Class[]{OpenNoteBlockInstrumentPacket.class, LooperUnplayablePacket.class, LooperPlayStatePacket.class, SyncModTagPacket.class});
    private static final String PROTOCOL_VERSION = "1.1";
    private static final PayloadRegistrar payloadRegistrar = new PayloadRegistrar("1.1");

    @SubscribeEvent
    public static void onPayloadRegistration(RegisterPayloadHandlersEvent event) {
        ServerUtil.registerC2SPackets(ACCEPTABLE_PACKETS_C2S, (PayloadRegistrar)payloadRegistrar);
        ServerUtil.registerS2CPackets(ACCEPTABLE_PACKETS_S2C, () -> ClientDistExecutor.PACKET_SWITCH, (PayloadRegistrar)payloadRegistrar);
    }

    public static void sendToServer(IModPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToClient(IModPacket packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

