/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking.packet.c2s;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.networking.IModPacket;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DoesLooperExistPacket
extends IModPacket {
    public static final String MOD_ID = "evenmoreinstruments";
    public static final StreamCodec<RegistryFriendlyByteBuf, DoesLooperExistPacket> CODEC = CustomPacketPayload.codec(DoesLooperExistPacket::write, DoesLooperExistPacket::new);
    public static final int MAX_RECORD_DIST = 8;
    final Optional<InteractionHand> hand;

    public DoesLooperExistPacket(InteractionHand hand) {
        this.hand = Optional.of(hand);
    }

    public DoesLooperExistPacket() {
        this.hand = Optional.empty();
    }

    public DoesLooperExistPacket(FriendlyByteBuf buf) {
        this.hand = buf.readOptional(fbb -> (InteractionHand)fbb.readEnum(InteractionHand.class));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeOptional(this.hand, FriendlyByteBuf::writeEnum);
    }

    public void handleServer(IPayloadContext context) {
        LooperBlockEntity looperBE;
        ServerPlayer player = (ServerPlayer)context.player();
        Level level = player.level();
        if (this.hand.isPresent()) {
            ItemStack instrumentItem = player.getItemInHand(this.hand.get());
            looperBE = LooperUtil.getFromItemInstrument(level, instrumentItem);
            if (looperBE != null && !looperBE.getBlockPos().closerToCenterThan((Position)player.position(), 8.0)) {
                looperBE = null;
                LooperUtil.remLooperTag(instrumentItem);
            }
        } else {
            BlockPos instrumentBlockPos = InstrumentOpenProvider.getBlockPos((Player)player);
            BlockEntity instrumentBlockEntity = level.getBlockEntity(instrumentBlockPos);
            looperBE = LooperUtil.getFromBlockInstrument(level, instrumentBlockEntity);
            if (looperBE == null) {
                EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag(instrumentBlockEntity), instrumentBlockPos), player);
            }
        }
        if (looperBE == null) {
            EMIPacketHandler.sendToClient(LooperUnplayablePacket.INSTANCE, player);
        }
    }
}

