/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking.packet.c2s;

import com.cstav.evenmoreinstruments.util.LooperRecordStateUtil;
import com.cstav.genshinstrument.networking.IModPacket;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class LooperRecordStatePacket
extends IModPacket {
    public static final String MOD_ID = "evenmoreinstruments";
    public static final StreamCodec<RegistryFriendlyByteBuf, LooperRecordStatePacket> CODEC = CustomPacketPayload.codec(LooperRecordStatePacket::write, LooperRecordStatePacket::new);
    private final Optional<InteractionHand> usedHand;
    private final boolean recording;

    public LooperRecordStatePacket(boolean recording, InteractionHand usedHand) {
        this.recording = recording;
        this.usedHand = Optional.ofNullable(usedHand);
    }

    public LooperRecordStatePacket(FriendlyByteBuf buf) {
        this.recording = buf.readBoolean();
        this.usedHand = buf.readOptional(fbb -> (InteractionHand)fbb.readEnum(InteractionHand.class));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.recording);
        buf.writeOptional(this.usedHand, FriendlyByteBuf::writeEnum);
    }

    public void handleServer(IPayloadContext context) {
        LooperRecordStateUtil.handle((ServerPlayer)context.player(), this.usedHand, this.recording);
    }
}

