/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.server.command;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.component.ModDataComponents;
import com.cstav.evenmoreinstruments.item.emirecord.RecordRepository;
import com.cstav.evenmoreinstruments.item.emirecord.WritableRecordItem;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class EMIRecordCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_RECORDS = (stack, builder) -> SharedSuggestionProvider.suggestResource(RecordRepository.listRecords(false), (SuggestionsBuilder)builder);
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(player -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.no_record", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_ALREADY_BURNED = new DynamicCommandExceptionType(player -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.record_already_burned", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_BURNED = new DynamicCommandExceptionType(player -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.record_burned", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_EMPTY = new DynamicCommandExceptionType(player -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.record_empty", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_INVALID = new DynamicCommandExceptionType(id -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.record_invalid", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType ERROR_TOO_MANY = new DynamicCommandExceptionType(player -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.too_many", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_INVALID_NAMESPACE = new DynamicCommandExceptionType(id -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.invalid_namespace", (Object[])new Object[]{"evenmoreinstruments", id}));
    private static final DynamicCommandExceptionType ERROR_ILLEGAL_NAME = new DynamicCommandExceptionType(name -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.failed.illegal_name", (Object[])new Object[]{name}));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emirecord").then(Commands.literal((String)"burn").then(((RequiredArgumentBuilder)Commands.argument((String)"record", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_RECORDS).executes(stack -> EMIRecordCommand.loadRecordToHand((CommandContext<CommandSourceStack>)stack, (Player)((CommandSourceStack)stack.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(stack -> stack.hasPermission(2))).executes(stack -> EMIRecordCommand.loadRecordToHand((CommandContext<CommandSourceStack>)stack, (Player)EntityArgument.getPlayer((CommandContext)stack, (String)"target"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"save").requires(stack -> stack.hasPermission(2))).then(Commands.argument((String)"record", (ArgumentType)ResourceLocationArgument.id()).executes(EMIRecordCommand::saveRecord)))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(stack -> stack.hasPermission(2))).then(Commands.argument((String)"record", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_RECORDS).executes(EMIRecordCommand::removeRecord))));
    }

    private static int saveRecord(CommandContext<CommandSourceStack> stack) throws CommandSyntaxException {
        ServerPlayer target = ((CommandSourceStack)stack.getSource()).getPlayerOrException();
        ResourceLocation saveLoc = ResourceLocationArgument.getId(stack, (String)"record");
        if (saveLoc.getNamespace().equals("evenmoreinstruments")) {
            throw ERROR_INVALID_NAMESPACE.create((Object)saveLoc);
        }
        if (saveLoc.getPath().contains(".")) {
            throw ERROR_ILLEGAL_NAME.create((Object)saveLoc);
        }
        Optional<ItemStack> record = CommonUtil.getItemInBothHands((Player)target, (Item)ModItems.RECORD_WRITABLE.get());
        if (record.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)target.getDisplayName());
        }
        if (!((WritableRecordItem)record.get().getItem()).isBurned(record.get())) {
            throw ERROR_RECORD_EMPTY.create((Object)target.getDisplayName());
        }
        CustomData channelTag = (CustomData)record.get().get((DataComponentType)ModDataComponents.CHANNEL.get());
        if (channelTag == null) {
            if (record.get().has((DataComponentType)ModDataComponents.BURNED_MEDIA.get())) {
                throw ERROR_RECORD_BURNED.create((Object)target.getDisplayName());
            }
            throw ERROR_RECORD_EMPTY.create((Object)target.getDisplayName());
        }
        try {
            RecordRepository.saveRecord(saveLoc, channelTag.copyTag());
        }
        catch (IOException e) {
            EMIMain.LOGGER.error("Error encountered while saving record data", (Throwable)e);
            throw new RuntimeException(e);
        }
        ((CommandSourceStack)stack.getSource()).sendSuccess(() -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.success.record_saved"), true);
        return 1;
    }

    private static int loadRecordToHand(CommandContext<CommandSourceStack> stack, Player target) throws CommandSyntaxException {
        Optional<ItemStack> record = CommonUtil.getItemInBothHands(target, (Item)ModItems.RECORD_WRITABLE.get());
        if (record.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)target.getDisplayName());
        }
        if (record.get().getCount() > 1) {
            throw ERROR_TOO_MANY.create((Object)target.getDisplayName());
        }
        if (((WritableRecordItem)record.get().getItem()).isBurned(record.get())) {
            throw ERROR_RECORD_ALREADY_BURNED.create((Object)target.getDisplayName());
        }
        ResourceLocation recordName = (ResourceLocation)stack.getArgument("record", ResourceLocation.class);
        Optional<CompoundTag> recordChannel = RecordRepository.getRecord(recordName);
        if (recordChannel.isEmpty()) {
            throw ERROR_RECORD_INVALID.create((Object)recordName);
        }
        record.get().set((DataComponentType)ModDataComponents.BURNED_MEDIA.get(), (Object)recordName);
        ((CommandSourceStack)stack.getSource()).sendSuccess(() -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.success.record_burned"), true);
        return 1;
    }

    private static int removeRecord(CommandContext<CommandSourceStack> stack) throws CommandSyntaxException {
        ResourceLocation name = ResourceLocationArgument.getId(stack, (String)"record");
        if (name.getNamespace().equals("evenmoreinstruments")) {
            throw ERROR_INVALID_NAMESPACE.create((Object)name);
        }
        try {
            RecordRepository.removeRecord(name);
        }
        catch (Exception e) {
            throw ERROR_RECORD_INVALID.create((Object)name);
        }
        ((CommandSourceStack)stack.getSource()).sendSuccess(() -> Component.translatable((String)"commands.evenmoreinstruments.emirecord.success.record_removed"), true);
        return 1;
    }
}

