/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.util;

import com.cstav.evenmoreinstruments.EMIMain;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CommonUtil {
    public static CompoundTag getOrCreateElementTag(CompoundTag parent, String key) {
        return CommonUtil.getOrCreateTag(parent, key, 10, CompoundTag::new);
    }

    public static ListTag getOrCreateListTag(CompoundTag parent, String key) {
        return CommonUtil.getOrCreateTag(parent, key, 9, ListTag::new);
    }

    public static <T extends Tag> T getOrCreateTag(CompoundTag parent, String key, int type, Supplier<T> orElse) {
        if (parent.contains(key, type)) {
            return (T)parent.get(key);
        }
        Tag tag = (Tag)orElse.get();
        parent.put(key, tag);
        return (T)tag;
    }

    public static InteractionHand getOffhand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static CompoundTag deepConvertCompound(CompoundTag compound, Map<String, String> oldToNewMapper) {
        CompoundTag result = new CompoundTag();
        compound.getAllKeys().forEach(key -> {
            String newKey = (String)oldToNewMapper.get(key);
            if (newKey == null) {
                return;
            }
            if (compound.contains(key, 10)) {
                result.put(newKey, (Tag)CommonUtil.deepConvertCompound(compound.getCompound(key), oldToNewMapper));
            } else if (compound.contains(key, 9)) {
                result.put(newKey, (Tag)CommonUtil.deepConvertList((ListTag)compound.get(key), oldToNewMapper));
            } else {
                result.put(newKey, compound.get(key).copy());
            }
        });
        return result;
    }

    public static ListTag deepConvertList(ListTag list, Map<String, String> oldToNewMapper) {
        ListTag result = new ListTag();
        list.forEach(tag -> {
            if (tag instanceof ListTag) {
                ListTag lt = (ListTag)tag;
                result.add((Object)CommonUtil.deepConvertList(lt, oldToNewMapper));
            } else if (tag instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)tag;
                result.add((Object)CommonUtil.deepConvertCompound(ct, oldToNewMapper));
            } else {
                result.add((Object)tag.copy());
            }
        });
        return result;
    }

    public static void moveTags(CompoundTag source, CompoundTag dest, String key) {
        Tag value = source.get(key);
        dest.put(key, value);
        source.remove(key);
    }

    public static void loadClasses(Class<?>[] classes) {
        for (Class<?> loadMe : classes) {
            try {
                Class.forName(loadMe.getName());
            }
            catch (ClassNotFoundException e) {
                EMIMain.LOGGER.error("Failed to load class " + loadMe.getSimpleName() + ": class not found", (Throwable)e);
            }
        }
    }

    public static Optional<ItemStack> getItemInBothHands(Player player, Item item) {
        ItemStack result = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (result.is(item)) {
            return Optional.of(result);
        }
        result = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (result.is(item)) {
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

