/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.util;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.s2c.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.s2c.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.evenmoreinstruments.util.ServerUtil;
import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LooperRecordStateUtil {
    public static void handle(ServerPlayer player, Optional<InteractionHand> hand, boolean recording) {
        if (hand.isPresent()) {
            LooperRecordStateUtil.handleItem(player, hand.get(), recording);
        } else {
            LooperRecordStateUtil.handleBlock(player, recording);
        }
    }

    public static void handleBlock(ServerPlayer player, boolean recording) {
        BlockPos instrumentBlockPos = InstrumentOpenProvider.getBlockPos((Player)player);
        BlockEntity instrumentBlock = player.level().getBlockEntity(instrumentBlockPos);
        CompoundTag looperTag = LooperUtil.looperTag(instrumentBlock);
        if (looperTag.isEmpty()) {
            return;
        }
        if (ServerUtil.isMaliciousPos((Player)player, looperTag)) {
            return;
        }
        LooperBlockEntity lbe = LooperUtil.getFromBlockInstrument(player.level(), instrumentBlock);
        if (lbe == null) {
            LooperRecordStateUtil.notifyLooperUnplayable(player);
            return;
        }
        LooperRecordStateUtil.changeRecordingState(player, lbe, () -> LooperUtil.remLooperTag(instrumentBlock), recording);
        EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag(instrumentBlock), instrumentBlockPos), player);
    }

    public static void handleItem(ServerPlayer player, InteractionHand hand, boolean recording) {
        ItemStack instrumentItem = player.getItemInHand(hand);
        CompoundTag looperTag = LooperUtil.looperTag(instrumentItem);
        if (looperTag.isEmpty()) {
            return;
        }
        if (ServerUtil.isMaliciousPos((Player)player, looperTag)) {
            return;
        }
        LooperBlockEntity lbe = LooperUtil.getFromItemInstrument(player.level(), instrumentItem);
        if (lbe == null) {
            LooperRecordStateUtil.notifyLooperUnplayable(player);
            return;
        }
        LooperRecordStateUtil.changeRecordingState(player, lbe, () -> LooperUtil.remLooperTag(instrumentItem), recording);
    }

    public static void changeRecordingState(ServerPlayer player, LooperBlockEntity lbe, Runnable looperTagRemover, boolean recording) {
        if (recording) {
            if (lbe.isLocked() && !lbe.isLockedBy((Player)player)) {
                LooperRecordStateUtil.notifyLooperUnplayable(player);
                return;
            }
            LooperUtil.setRecording((Player)player, lbe.getBlockPos());
        } else {
            if (!lbe.isLockedBy((Player)player)) {
                return;
            }
            lbe.lock();
            player.level().setBlockAndUpdate(lbe.getBlockPos(), lbe.setPlaying(true, lbe.getBlockState()));
            looperTagRemover.run();
            LooperUtil.setNotRecording((Player)player);
        }
    }

    private static void notifyLooperUnplayable(ServerPlayer player) {
        EMIPacketHandler.sendToClient(LooperUnplayablePacket.INSTANCE, player);
    }
}

