/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.entity;

import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BasicAreaParticleCloud
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ParticleOptions> PARTICLE = SynchedEntityData.defineId(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.PARTICLE);
    private static final EntityDataAccessor<Float> SPAWN_RATE = SynchedEntityData.defineId(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int duration = 60;
    private int waitTime = 0;
    private float radiusPerTick = 0.0f;

    public BasicAreaParticleCloud(@NotNull EntityType type, @NotNull Level worldIn) {
        super(type, worldIn);
        this.noPhysics = true;
        this.setRadius(3.0f);
    }

    public int getColor() {
        return (Integer)this.getEntityData().get(COLOR);
    }

    public void setColor(int colorIn) {
        this.getEntityData().set(COLOR, (Object)colorIn);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @NotNull
    public ParticleOptions getParticle() {
        return (ParticleOptions)this.getEntityData().get(PARTICLE);
    }

    public void setParticle(@NotNull ParticleOptions particleData) {
        this.getEntityData().set(PARTICLE, (Object)particleData);
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        this.dimensions = EntityDimensions.fixed((float)(radius * 2.0f), (float)this.getBbHeight());
        this.setPos(d0, d1, d2);
        if (!this.level().isClientSide) {
            this.getEntityData().set(RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public float getSpawnRate() {
        return ((Float)this.getEntityData().get(SPAWN_RATE)).floatValue();
    }

    public void setSpawnRate(float rate) {
        this.getEntityData().set(SPAWN_RATE, (Object)Float.valueOf(rate));
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public boolean save(@NotNull CompoundTag compound) {
        return false;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public boolean saveAsPassenger(@NotNull CompoundTag compound) {
        return false;
    }

    public void setHeight(float height) {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        this.dimensions = EntityDimensions.fixed((float)(this.getRadius() * 2.0f), (float)height);
        this.setPos(d0, d1, d2);
        if (!this.level().isClientSide) {
            this.getEntityData().set(HEIGHT, (Object)Float.valueOf(height));
        }
    }

    public void tick() {
        super.tick();
        float radius = this.getRadius();
        if (this.level().isClientSide) {
            ParticleOptions particle = this.getParticle();
            float amount = (float)(Math.PI * (double)radius * (double)radius) * this.getSpawnRate();
            int i = 0;
            while ((float)i < amount) {
                float phi = this.random.nextFloat() * (float)Math.PI * 2.0f;
                float r = Mth.sqrt((float)this.random.nextFloat()) * radius;
                float dx = Mth.cos((float)phi) * r;
                float dz = Mth.sin((float)phi) * r;
                float dy = this.random.nextFloat() * this.getBbHeight();
                if (particle.getType() == ParticleTypes.ENTITY_EFFECT) {
                    int rgb = this.getColor();
                    int cr = rgb >> 16 & 0xFF;
                    int cg = rgb >> 8 & 0xFF;
                    int cb = rgb & 0xFF;
                    this.level().addParticle(particle, this.getX() + (double)dx, this.getY() + (double)dy, this.getZ() + (double)dz, (double)((float)cr / 255.0f), (double)((float)cg / 255.0f), (double)((float)cb / 255.0f));
                } else {
                    this.level().addParticle(particle, this.getX() + (double)dx, this.getY() + (double)dy, this.getZ() + (double)dz, (0.5 - this.random.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.random.nextDouble()) * 0.15);
                }
                ++i;
            }
        } else {
            if (this.tickCount >= this.waitTime + this.duration) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (this.tickCount < this.waitTime) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.3f) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                    return;
                }
                this.setRadius(radius);
            }
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(COLOR, (Object)0);
        builder.define(RADIUS, (Object)Float.valueOf(0.5f));
        builder.define(HEIGHT, (Object)Float.valueOf(0.5f));
        builder.define(PARTICLE, (Object)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1));
        builder.define(SPAWN_RATE, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }
}

