/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryHelper {
    @NotNull
    public static ItemStack checkItems(@NotNull Container inventory, Item @NotNull [] items, int @NotNull [] amounts, @NotNull BiPredicate<Item, Item> compareFunction) {
        if (inventory.getContainerSize() < amounts.length || items.length != amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack and amount value for each item");
        }
        for (int i = 0; i < items.length; ++i) {
            int actual;
            ItemStack stack = inventory.getItem(i);
            int n = actual = !stack.isEmpty() && compareFunction.test(stack.getItem(), items[i]) ? stack.getCount() : 0;
            if (actual >= amounts[i]) continue;
            return new ItemStack((ItemLike)items[i], amounts[i] - actual);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack checkItems(@NotNull Container inventory, Item @NotNull [] items, int @NotNull [] amounts) {
        return InventoryHelper.checkItems(inventory, items, amounts, Object::equals);
    }

    public static void removeItems(@NotNull Container inventory, int ... amounts) {
        if (inventory.getContainerSize() < amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack value for each amount");
        }
        for (int i = 0; i < amounts.length; ++i) {
            inventory.removeItem(i, amounts[i]);
        }
    }

    @NotNull
    public static Optional<Pair<IItemHandler, BlockEntity>> tryGetItemHandler(@NotNull Level world, @NotNull BlockPos pos, @Nullable Direction side) {
        BlockEntity tile;
        BlockState state = world.getBlockState(pos);
        if (state.hasBlockEntity() && (tile = world.getBlockEntity(pos)) != null) {
            return Optional.ofNullable((IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, tile, (Object)side)).map(s -> ImmutablePair.of((Object)s, (Object)tile));
        }
        return Optional.empty();
    }

    public static boolean canMergeStacks(@NotNull ItemStack stack1, @NotNull ItemStack stack2, int invLimit) {
        return !stack1.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2) && stack1.isStackable() && stack1.getCount() < stack1.getMaxStackSize() && stack1.getCount() < Math.min(invLimit, stack1.getMaxStackSize());
    }

    public static void addStackToSlotWithoutCheck(@NotNull Container inv, int slot, @NotNull ItemStack addStack) {
        int newCount = addStack.getCount();
        ItemStack existingStack = inv.getItem(slot);
        int oldCount = existingStack.getCount();
        int addAmount = Math.min(newCount, Math.min(inv.getMaxStackSize() - oldCount, addStack.getMaxStackSize() - oldCount));
        if (addAmount == 0) {
            return;
        }
        if (existingStack.isEmpty()) {
            existingStack = addStack.copy();
            existingStack.setCount(0);
            existingStack.applyComponents(addStack.getComponents());
            inv.setItem(slot, existingStack);
        }
        existingStack.grow(addAmount);
        addStack.shrink(addAmount);
    }

    public static int getFirstSuitableSlotToAdd(@NotNull NonNullList<ItemStack> inventory, @NotNull ItemStack stack, int invLimit) {
        return InventoryHelper.getFirstSuitableSlotToAdd(inventory, inventory.size(), stack, invLimit);
    }

    public static int getFirstSuitableSlotToAdd(@NotNull NonNullList<ItemStack> inventory, int inventorySize, @NotNull ItemStack stack, int invLimit) {
        int i;
        assert (inventory.size() >= inventorySize);
        if (!stack.isDamaged() && stack.isStackable()) {
            for (i = 0; i < inventorySize; ++i) {
                if (!InventoryHelper.canMergeStacks((ItemStack)inventory.get(i), stack, invLimit)) continue;
                return i;
            }
        }
        for (i = 0; i < inventorySize; ++i) {
            if (!((ItemStack)inventory.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static boolean removeItemFromInventory(@NotNull Container inventory, @NotNull ItemStack item) {
        int i = item.getCount();
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemstack = inventory.getItem(j);
            if (!itemstack.getItem().equals(item.getItem())) continue;
            if (itemstack.getCount() >= i) {
                itemstack.shrink(i);
                return true;
            }
            int l = itemstack.getCount();
            itemstack.shrink(i);
            i -= l;
        }
        return i <= 0;
    }

    @Nullable
    public static ItemStack getFirst(@NotNull Container inventory, Item set) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            if (set != itemstack.getItem() || itemstack.getCount() <= 0) continue;
            return itemstack;
        }
        return null;
    }
}

