/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.actions;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public interface IEntityActionUser
extends IAdjustableLevel,
IFactionEntity {
    public static <T extends LivingEntity> void applyAttributes(@NotNull T entity) {
        entity.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(((IEntityActionUser)entity).getEntityClass().getHealthModifier());
        entity.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(((IEntityActionUser)entity).getEntityClass().getDamageModifier());
        entity.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(((IEntityActionUser)entity).getEntityClass().getSpeedModifier());
    }

    public IActionHandlerEntity getActionHandler();

    default public List<IEntityAction> getAvailableActions() {
        return VampirismAPI.entityActionManager().getAllEntityActionsByTierAndClassType(this.getFaction(), this.getEntityTier(), this.getEntityClass());
    }

    default public EntityClassType getEntityClass() {
        return EntityClassType.None;
    }

    default public EntityActionTier getEntityTier() {
        return EntityActionTier.Default;
    }
}

