/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.convertible;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICurableConvertedCreature<T extends PathfinderMob>
extends IConvertedCreature<T> {
    public static final byte CURE_EVENT_ID = 40;

    default public T createCuredEntity(@NotNull PathfinderMob entity, @NotNull EntityType<T> newType) {
        PathfinderMob newEntity = (PathfinderMob)newType.create(entity.level());
        if (!1.$assertionsDisabled && newEntity == null) {
            throw new AssertionError();
        }
        newEntity.load(entity.saveWithoutId(new CompoundTag()));
        newEntity.yBodyRot = entity.yBodyRot;
        newEntity.yHeadRot = entity.yHeadRot;
        newEntity.setUUID(UUID.randomUUID());
        return (T)newEntity;
    }

    default public T cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<T> newType) {
        T newEntity = this.createCuredEntity(entity, newType);
        entity.remove(Entity.RemovalReason.DISCARDED);
        entity.level().addFreshEntity(newEntity);
        newEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
        if (!entity.isSilent()) {
            world.levelEvent(null, 1027, entity.blockPosition(), 0);
        }
        VampirismAPI.extendedCreatureVampirism(newEntity).setBlood(1);
        EventHooks.onLivingConvert((LivingEntity)entity, newEntity);
        return newEntity;
    }

    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam();

    @Nullable
    default public EntityDataAccessor<String> getSourceEntityDataParam() {
        return null;
    }

    @Deprecated
    @NotNull
    default public Optional<EntityDataAccessor<String>> getSourceEntityDataParamOpt() {
        return Optional.ofNullable(this.getSourceEntityDataParam());
    }

    @Override
    @Nullable
    default public String getSourceEntityId() {
        return this.getSourceEntityDataParamOpt().map(s -> (String)this.asEntity().getEntityData().get(s)).orElse(null);
    }

    default public boolean handleSound(byte id, @NotNull PathfinderMob entity) {
        if (id == 40) {
            if (!entity.isSilent()) {
                entity.level().playLocalSound(entity.getX(), entity.getEyeY(), entity.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, entity.getSoundSource(), 1.0f + entity.getRandom().nextFloat(), entity.getRandom().nextFloat() * 0.7f + 0.3f, false);
            }
            return true;
        }
        return false;
    }

    @NotNull
    default public InteractionResult interactWithCureItem(@NotNull Player player, @NotNull ItemStack stack, @NotNull PathfinderMob entity) {
        if (this.isConverting(entity)) {
            return InteractionResult.CONSUME;
        }
        if (!entity.hasEffect(MobEffects.WEAKNESS)) {
            return InteractionResult.CONSUME;
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (!entity.level().isClientSide) {
            this.startConverting(player.getUUID(), entity.getRandom().nextInt(2400) + 2400, entity);
        }
        return InteractionResult.SUCCESS;
    }

    default public boolean isConverting(@NotNull PathfinderMob entity) {
        return (Boolean)entity.getEntityData().get(this.getConvertingDataParam());
    }

    default public void registerConvertingData(@NotNull SynchedEntityData.Builder builder) {
        builder.define(this.getConvertingDataParam(), (Object)false);
        this.getSourceEntityDataParamOpt().ifPresent(s -> builder.define(s, (Object)""));
    }

    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @NotNull PathfinderMob entity) {
        entity.getEntityData().set(this.getConvertingDataParam(), (Object)true);
        entity.removeEffect(MobEffects.WEAKNESS);
        entity.level().broadcastEntityEvent((Entity)entity, (byte)40);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

