/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPointProvider;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.util.Collections;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class SkillPointProviders {
    private static final BiMap<ResourceLocation, ISkillPointProvider> MODIFIERS = HashBiMap.create();
    public static final Map<ResourceLocation, ISkillPointProvider> MODIFIERS_VIEW = Collections.unmodifiableMap(MODIFIERS);

    public static ISkillPointProvider register(ResourceLocation id, ISkillPointProvider modifier) {
        if (MODIFIERS.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate modifier id " + String.valueOf(id));
        }
        MODIFIERS.put((Object)id, (Object)modifier);
        return modifier;
    }

    public static ResourceLocation getId(ISkillPointProvider modifier) {
        ResourceLocation result = (ResourceLocation)MODIFIERS.inverse().get((Object)modifier);
        if (result == null) {
            throw new IllegalArgumentException("Modifier not registered " + String.valueOf(modifier));
        }
        return result;
    }

    static {
        SkillPointProviders.register(VResourceLocation.mod("none"), factionPlayer -> 0);
    }
}

