/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismDataComponents;
import de.teamlapen.vampirism.api.components.IAppliedOilContent;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IFactionExclusiveItem
extends ItemLike {
    default public void addFactionToolTips(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        this.addOilDescTooltip(stack, context, tooltip, flagIn, player);
        ChatFormatting color = ChatFormatting.GRAY;
        IFaction<?> faction = this.getExclusiveFaction(stack);
        if (faction != null) {
            if (player != null) {
                color = VampirismAPI.factionRegistry().getFaction((Entity)player) == faction ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED;
            }
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"text.vampirism.faction_exclusive", (Object[])new Object[]{faction.getName().copy().withStyle(color)}));
        }
    }

    default public void addOilDescTooltip(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        IAppliedOilContent appliedOil = (IAppliedOilContent)stack.get(VampirismDataComponents.APPLIED_OIL.get());
        if (appliedOil != null && appliedOil.duration() > 0) {
            ((IApplicableOil)appliedOil.oil().value()).getToolTipLine(stack, (IApplicableOil)appliedOil.oil().value(), appliedOil.duration(), flagIn).ifPresent(tooltip::add);
        }
    }

    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack var1);
}

