/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.fluids.BloodFluid;
import de.teamlapen.vampirism.fluids.ImpureBloodFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class BloodContainerBlockEntity
extends BlockEntity
implements FluidTankWithListener.IFluidTankListener {
    public static final int LEVEL_AMOUNT = 900;
    public static final int CAPACITY = 12600;
    public static final ModelProperty<Integer> FLUID_LEVEL_PROP = new ModelProperty();
    public static final ModelProperty<Boolean> FLUID_IMPURE = new ModelProperty();
    private final FluidTankWithListener tank = new FluidTankWithListener(12600, fluidStack -> ((BloodFluid)((Object)((Object)ModFluids.BLOOD.get()))).isSame(fluidStack.getFluid()) || ((ImpureBloodFluid)((Object)((Object)ModFluids.IMPURE_BLOOD.get()))).isSame(fluidStack.getFluid())).setListener(this);

    public BloodContainerBlockEntity(@NotNull BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.BLOOD_CONTAINER.get(), pos, state);
    }

    @NotNull
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @NotNull
    public ModelData getModelData() {
        FluidStack fluid = this.tank.getFluid();
        int l = 0;
        if (!fluid.isEmpty()) {
            float amount = (float)fluid.getAmount() / 900.0f;
            l = amount > 0.0f && amount < 1.0f ? 1 : (int)amount;
        }
        return ModelData.builder().with(FLUID_LEVEL_PROP, (Object)l).with(FLUID_IMPURE, (Object)fluid.getFluid().equals(ModFluids.IMPURE_BLOOD.get())).build();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        CompoundTag tag = new CompoundTag();
        this.tank.writeToNBT(provider, tag);
        pTag.put("tank", (Tag)tag);
    }

    public void loadAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.tank.readFromNBT(provider, pTag.getCompound("tank"));
        this.setChanged();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = this.saveWithoutMetadata(provider);
        this.tank.writeToNBT(provider, tag);
        return tag;
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        int oldAmount = this.tank.getFluid().getAmount();
        Fluid fluid = this.tank.getFluid().getFluid();
        this.tank.readFromNBT(provider, pkt.getTag());
        if (oldAmount != this.tank.getFluid().getAmount() || fluid != this.tank.getFluid().getFluid()) {
            this.setChanged();
        }
    }

    @NotNull
    public FluidTankWithListener getTank() {
        return this.tank;
    }

    @Override
    public void onTankContentChanged() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setChanged() {
        if (this.level != null && this.level.isClientSide) {
            this.requestModelDataUpdate();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        super.setChanged();
    }

    public void setFluidStack(FluidStack stack) {
        this.tank.setFluid(stack);
    }
}

