/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.blockentity.InventoryBlockEntity;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.datamaps.IItemBlood;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.BloodGrinderMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class BloodGrinderBlockEntity
extends InventoryBlockEntity {
    @NotNull
    private final IItemHandler itemHandler = new InventoryBlockEntity.SelectorInvWrapper(this);
    private int cooldownPull = 0;
    private int cooldownProcess = 0;

    @NotNull
    private static List<ItemEntity> getCaptureItems(@NotNull Level worldIn, @NotNull BlockPos pos) {
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        return worldIn.getEntitiesOfClass(ItemEntity.class, new AABB((double)posX, (double)posY + 0.5, (double)posZ, (double)posX + 1.0, (double)posY + 1.5, (double)posZ + 1.0), EntitySelector.ENTITY_STILL_ALIVE);
    }

    public BloodGrinderBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.GRINDER.get(), pos, state, 1, BloodGrinderMenu.SELECTOR_INFOS);
    }

    @NotNull
    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.cooldownPull = tagCompound.getInt("cooldown_pull");
        this.cooldownProcess = tagCompound.getInt("cooldown_process");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("cooldown_pull", this.cooldownPull);
        compound.putInt("cooldown_process", this.cooldownProcess);
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull BloodGrinderBlockEntity blockEntity) {
        --blockEntity.cooldownPull;
        if (blockEntity.cooldownPull <= 0) {
            boolean flag;
            blockEntity.cooldownPull = 10;
            if (!blockEntity.isFull() && (flag = BloodGrinderBlockEntity.pullItems(blockEntity, level, pos))) {
                blockEntity.cooldownPull = 20;
            }
        }
        --blockEntity.cooldownProcess;
        if (blockEntity.cooldownProcess <= 0) {
            blockEntity.cooldownProcess = 10;
            blockEntity.updateProcess();
        }
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new BloodGrinderMenu(id, player, (Container)this, ContainerLevelAccess.create((Level)player.player.getCommandSenderWorld(), (BlockPos)this.getBlockPos()));
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"tile.vampirism.blood_grinder");
    }

    private static boolean pullItems(@NotNull BloodGrinderBlockEntity blockEntity, @NotNull Level level, @NotNull BlockPos pos) {
        boolean flag = InventoryHelper.tryGetItemHandler(level, pos.above(), Direction.DOWN).map(pair -> {
            IItemHandler handler = (IItemHandler)pair.getLeft();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack simulated;
                ItemStack extracted = handler.extractItem(i, 1, true);
                if (extracted.isEmpty() || !(simulated = ItemHandlerHelper.insertItemStacked((IItemHandler)blockEntity.itemHandler, (ItemStack)extracted, (boolean)true)).isEmpty()) continue;
                extracted = handler.extractItem(i, 1, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)blockEntity.itemHandler, (ItemStack)extracted, (boolean)false);
                return true;
            }
            return false;
        }).orElse(false);
        if (flag) {
            return true;
        }
        for (ItemEntity entityItem : BloodGrinderBlockEntity.getCaptureItems(level, pos)) {
            ItemStack stack = entityItem.getItem();
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                ItemStack stack2 = blockEntity.itemHandler.insertItem(i, stack, true);
                if (!stack2.isEmpty()) continue;
                stack2 = blockEntity.itemHandler.insertItem(i, stack, false);
                if (stack2.getCount() < stack.getCount()) {
                    entityItem.discard();
                } else {
                    entityItem.setItem(stack2);
                }
                return true;
            }
        }
        return false;
    }

    private void updateProcess() {
        if (this.level != null && !this.isEmpty()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                int slot = i;
                ItemStack stack = this.itemHandler.extractItem(i, 1, true);
                IItemBlood data = VampirismAPI.bloodConversionRegistry().getItemBlood(stack);
                if (data.blood() <= 0) continue;
                FluidStack fluid = new FluidStack((Fluid)ModFluids.IMPURE_BLOOD.get(), data.blood());
                FluidUtil.getFluidHandler((Level)this.level, (BlockPos)this.worldPosition.below(), (Direction)Direction.UP).ifPresent(handler -> {
                    int filled = handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                    if ((float)filled >= 0.9f * (float)data.blood()) {
                        ItemStack extractedStack = this.itemHandler.extractItem(slot, 1, false);
                        handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.GRINDER.get(), SoundSource.BLOCKS, 0.5f, 0.7f);
                        this.cooldownProcess = Mth.clamp((int)(20 * filled / 100), (int)20, (int)100);
                    }
                });
            }
        }
    }
}

