/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.SpawnHelper;
import de.teamlapen.vampirism.blockentity.VulnerableRemainsBlockEntity;
import de.teamlapen.vampirism.blocks.mother.IRemainsBlock;
import de.teamlapen.vampirism.blocks.mother.MotherTreeStructure;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.GhostEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ClientboundBossEventSoundPacket;
import de.teamlapen.vampirism.network.ClientboundPlayEventPacket;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MotherBlockEntity
extends BlockEntity {
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.translatable((String)"block.vampirism.mother"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private final Set<ServerPlayer> activePlayers = new HashSet<ServerPlayer>();
    private final Set<UUID> involvedPlayers = new HashSet<UUID>();
    private MotherTreeStructure cachedStructure;
    private boolean isFrozen = false;
    private int freezeTimer = 0;
    @Nullable
    private AABB area;
    private int destructionTimer = 0;

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MotherBlockEntity e) {
        if (e.isFrozen && e.freezeTimer-- <= 0) {
            e.unFreezeFight(level, blockPos, blockState);
        }
        if (!e.isFrozen && e.level != null && e.isIntact()) {
            if (e.level.getRandom().nextInt(50) == 0) {
                List<Triple> vuls;
                e.updateFightStatus();
                if (!e.activePlayers.isEmpty() && !(vuls = e.getTreeStructure(false).getVerifiedVulnerabilities(level).filter(t -> ((IRemainsBlock)t.getRight()).isVulnerable((BlockState)t.getMiddle())).toList()).isEmpty()) {
                    for (ServerPlayer player2 : e.activePlayers) {
                        if (player2.getAbilities().invulnerable) continue;
                        BlockPos p = (BlockPos)vuls.get(e.level.getRandom().nextInt(vuls.size())).getLeft();
                        player2.addEffect(new MobEffectInstance(MobEffects.HUNGER, 100, 2));
                        ModParticles.spawnParticlesServer(player2.level(), new FlyingBloodParticleOptions(100, false, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, 0.5f), player2.getX(), player2.getY() + (double)(player2.getEyeHeight() / 2.0f), player2.getZ(), 5, 0.1f, 0.1f, 0.1f, 0.0);
                    }
                }
            }
            if (e.level.getRandom().nextFloat() < Math.max(0.02f, Math.min(0.1f, (float)e.activePlayers.size() * 0.002f))) {
                Set<BlockPos> blocks = e.getTreeStructure(false).getCachedBlocks();
                if ((double)e.level.getEntitiesOfClass(GhostEntity.class, e.getArea().inflate(10.0)).size() < Math.min((double)e.activePlayers.size() * 1.6, 10.0)) {
                    blocks.stream().skip(e.level.getRandom().nextInt(blocks.size())).findFirst().ifPresent(pos -> e.spawnGhost(level, (BlockPos)pos));
                }
            }
        }
        if (e.level != null && e.destructionTimer > 0 && e.destructionTimer++ % 3 == 0) {
            MotherTreeStructure structure = e.getTreeStructure(false);
            Optional<Set<BlockPos>> hierarchy = structure.popHierarchy();
            if (hierarchy.isPresent()) {
                for (BlockPos p : hierarchy.get()) {
                    if (!(level.getBlockState(p).getBlock() instanceof IRemainsBlock)) continue;
                    level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
                    ModParticles.spawnParticlesServer(level, (ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.7f, 0.7f), 1.0f), (double)p.getX() + 0.5, (double)p.getY() + 0.5, (float)p.getZ() + 0.5f, 20, 0.3, 0.3, 0.3, 0.01);
                    e.level.playSound(null, p, (SoundEvent)ModSounds.REMAINS_DEATH.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
                }
            } else {
                e.destructionTimer = -1;
                if (e.level != null) {
                    e.level.playSound(null, blockPos, (SoundEvent)ModSounds.MOTHER_DEATH.get(), SoundSource.BLOCKS, 2.0f, 0.8f);
                }
                e.concludeFight();
            }
        }
        if (level.getGameTime() % 64L == 0L) {
            AABB area = e.getArea();
            Stream.concat(e.activePlayers.stream(), e.bossEvent.getPlayers().stream()).distinct().filter(player -> area.distanceToSqr(player.position()) > 1600.0).toList().forEach(player -> {
                e.bossEvent.removePlayer(player);
                e.activePlayers.remove(player);
            });
            AABB inflate = area.inflate(5.0, 5.0, 5.0);
            AABB inflate2 = inflate.inflate(10.0, 10.0, 10.0);
            if (!e.activePlayers.isEmpty()) {
                inflate = inflate.inflate(10.0, 10.0, 10.0);
                inflate2 = inflate2.inflate(20.0, 10.0, 20.0);
            }
            if (e.isIntact()) {
                level.getEntitiesOfClass(ServerPlayer.class, inflate).forEach(e::addPlayer);
            }
            level.getEntitiesOfClass(ServerPlayer.class, inflate2).forEach(e::addPlayerToBossEvent);
        }
    }

    public MotherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.MOTHER.get(), pos, state);
        this.bossEvent.setProgress(1.0f);
        this.bossEvent.setPlayBossMusic(true);
    }

    public boolean isCanBeBroken() {
        return this.destructionTimer == -1;
    }

    public boolean isIntact() {
        return this.destructionTimer == 0;
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.destructionTimer = tag.getInt("destruction_timer");
        this.isFrozen = tag.getBoolean("is_frozen");
        this.freezeTimer = tag.getInt("freeze_timer");
        if (this.isFrozen) {
            this.bossEvent.setColor(BossEvent.BossBarColor.WHITE);
        }
        this.involvedPlayers.clear();
        if (tag.contains("involved_players", 9)) {
            ListTag involvedPlayers = tag.getList("involved_players", 11);
            for (Tag involvedPlayer : involvedPlayers) {
                this.involvedPlayers.add(NbtUtils.loadUUID((Tag)involvedPlayer));
            }
        }
    }

    public void onStructureBlockRemoved() {
        this.cachedStructure = null;
    }

    public void setRemoved() {
        super.setRemoved();
        this.bossEvent.removeAllPlayers();
        this.activePlayers.clear();
    }

    private void addPlayer(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && !this.activePlayers.contains(serverPlayer = (ServerPlayer)player)) {
            this.updateFightStatus();
            this.addPlayerToBossEvent(serverPlayer);
            this.activePlayers.add(serverPlayer);
        }
    }

    private void addPlayerToBossEvent(ServerPlayer player) {
        this.bossEvent.addPlayer(player);
        player.connection.send((CustomPacketPayload)new ClientboundBossEventSoundPacket(this.bossEvent.getId(), (ResourceKey<SoundEvent>)ModSounds.MOTHER_AMBIENT.getKey()));
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onVulnerabilityHit(LivingEntity entity, boolean destroyed) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.informAboutAttacker(player);
        }
        this.updateFightStatus();
        if (destroyed && this.isIntact()) {
            this.freezeFight();
        }
    }

    public void updateFightStatus() {
        List<Triple<BlockPos, BlockState, IRemainsBlock>> vuls = this.getTreeStructure(false).getVerifiedVulnerabilities(this.level).toList();
        List<Triple> remaining = vuls.stream().filter(vul -> ((IRemainsBlock)vul.getRight()).isVulnerable((BlockState)vul.getMiddle())).toList();
        if (!remaining.isEmpty()) {
            int remainingHealth = remaining.stream().mapToInt(s -> {
                BlockEntity entity;
                if (this.level.isLoaded((BlockPos)s.getLeft()) && (entity = this.level.getBlockEntity((BlockPos)s.getLeft())) instanceof VulnerableRemainsBlockEntity) {
                    VulnerableRemainsBlockEntity vulnerable = (VulnerableRemainsBlockEntity)entity;
                    return vulnerable.getHealth();
                }
                return 100;
            }).sum();
            this.bossEvent.setProgress((float)remainingHealth / ((float)vuls.size() * 100.0f));
        } else {
            this.bossEvent.setProgress(0.0f);
            this.endFight();
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("destruction_timer", this.destructionTimer);
        tag.putBoolean("is_frozen", this.isFrozen);
        tag.putInt("freeze_timer", this.freezeTimer);
        ListTag involvedPlayers = new ListTag();
        for (UUID involvedPlayer : this.involvedPlayers) {
            involvedPlayers.add((Object)NbtUtils.createUUID((UUID)involvedPlayer));
        }
        tag.put("involved_players", (Tag)involvedPlayers);
    }

    private void endFight() {
        this.activePlayers.forEach(p -> p.connection.send((CustomPacketPayload)new ClientboundPlayEventPacket(2, this.getBlockPos(), 0)));
        this.bossEvent.removeAllPlayers();
        this.bossEvent.setVisible(false);
        this.activePlayers.clear();
        this.initiateDestruction();
    }

    private void freezeFight() {
        this.spawnGhosts();
        this.isFrozen = true;
        this.freezeTimer = 400;
        this.getTreeStructure(false).getVerifiedVulnerabilities(this.level).forEach(vul -> ((IRemainsBlock)vul.getRight()).freeze(this.level, (BlockPos)vul.getLeft(), (BlockState)vul.getMiddle()));
        this.bossEvent.setColor(BossEvent.BossBarColor.WHITE);
    }

    @NotNull
    private MotherTreeStructure getTreeStructure(boolean forceRefresh) {
        if (forceRefresh || this.cachedStructure == null) {
            this.cachedStructure = MotherTreeStructure.getTreeView(this.level, this.worldPosition);
        }
        return this.cachedStructure;
    }

    private void initiateDestruction() {
        this.getTreeStructure(true);
        this.destructionTimer = 1;
    }

    private void unFreezeFight(Level level, BlockPos blockPos, BlockState blockState) {
        this.isFrozen = false;
        this.getTreeStructure(false).getVerifiedVulnerabilities(this.level).forEach(vul -> ((IRemainsBlock)vul.getRight()).unFreeze(level, (BlockPos)vul.getLeft(), (BlockState)vul.getMiddle()));
        this.bossEvent.setColor(BossEvent.BossBarColor.RED);
    }

    public void informAboutAttacker(ServerPlayer serverPlayer) {
        this.addPlayer((Player)serverPlayer);
        this.involvedPlayers.add(serverPlayer.getUUID());
    }

    public Collection<ServerPlayer> involvedPlayers() {
        return this.activePlayers;
    }

    private void spawnGhost(Level level, BlockPos pos) {
        SpawnHelper.spawn(ModEntities.GHOST, level, ghost -> {
            ghost.setPos(Vec3.atCenterOf((Vec3i)pos));
            ghost.setHome(this.getArea().inflate(15.0));
        });
    }

    private AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.worldPosition).inflate(9.0, 0.0, 9.0).expandTowards(0.0, -10.0, 0.0).expandTowards(0.0, 4.0, 0.0);
        }
        return this.area;
    }

    private void spawnGhosts() {
        int size;
        Set<BlockPos> vuls = this.getTreeStructure(false).getCachedBlocks();
        int i = size = this.level.getEntitiesOfClass(GhostEntity.class, this.getArea()).size();
        while ((double)i < Math.max(3.0, Math.min((double)this.activePlayers.size() * 1.6, 10.0))) {
            vuls.stream().skip(this.level.getRandom().nextInt(vuls.size())).findFirst().ifPresent(pos -> this.spawnGhost(this.level, (BlockPos)pos));
            ++i;
        }
    }

    public void concludeFight() {
        Set involvedEntities = this.involvedPlayers.stream().map(arg_0 -> ((ServerLevel)((ServerLevel)this.level)).getEntity(arg_0)).filter(LivingEntity.class::isInstance).filter(s -> !s.isSpectator()).map(LivingEntity.class::cast).collect(Collectors.toSet());
        for (LivingEntity livingentity : involvedEntities) {
            if (!(livingentity instanceof ServerPlayer)) continue;
            ServerPlayer serverplayer = (ServerPlayer)livingentity;
            ((PlayerTrigger)ModAdvancements.TRIGGER_MOTHER_WIN.get()).trigger(serverplayer);
            serverplayer.awardStat((ResourceLocation)ModStats.MOTHER_DEFEATED.get(), 1);
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)serverplayer);
            if (handler.getCurrentFaction() == null || handler.getCurrentLevel() >= handler.getCurrentFaction().getHighestReachableLevel()) continue;
            handler.setFactionLevel(handler.getCurrentFaction(), handler.getCurrentLevel() + 1);
        }
    }
}

