/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.SimpleSpawnerLogic;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VEnums;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class TentBlockEntity
extends BlockEntity {
    @NotNull
    private final SimpleSpawnerLogic<BasicHunterEntity> spawnerLogicHunter;
    @NotNull
    private final SimpleSpawnerLogic<AdvancedHunterEntity> spawnerLogicAdvancedHunter;
    private boolean spawn = false;
    private boolean advanced = false;

    public TentBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.TENT.get(), pos, state);
        this.spawnerLogicHunter = new SimpleSpawnerLogic((EntityType)ModEntities.HUNTER.get()).setActivateRange(64).setSpawnRange(6).setMinSpawnDelay(600).setMaxSpawnDelay(1000).setMaxNearbyEntities(2).setDailyLimit((Integer)VampirismConfig.BALANCE.hunterTentMaxSpawn.get()).setLimitTotalEntities((MobCategory)VEnums.HUNTER_CATEGORY.getValue()).setOnSpawned(hunter -> hunter.makeCampHunter(this.worldPosition));
        this.spawnerLogicAdvancedHunter = new SimpleSpawnerLogic((EntityType)ModEntities.ADVANCED_HUNTER.get()).setActivateRange(64).setSpawnRange(6).setMinSpawnDelay(1200).setMaxSpawnDelay(2000).setMaxNearbyEntities(1).setDailyLimit(1).setLimitTotalEntities((MobCategory)VEnums.HUNTER_CATEGORY.getValue()).setOnSpawned(hunter -> hunter.makeCampHunter(this.worldPosition));
    }

    public boolean isSpawner() {
        return this.spawn;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("spawner_logic_1")) {
            this.spawnerLogicHunter.readFromNbt(nbt.getCompound("spawner_logic_1"));
        }
        if (nbt.contains("spawner_logic_2")) {
            this.spawnerLogicAdvancedHunter.readFromNbt(nbt.getCompound("spawner_logic_2"));
        }
        if (nbt.contains("advanced")) {
            this.advanced = nbt.getBoolean("advanced");
        }
        this.spawn = nbt.getBoolean("spawn");
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        CompoundTag logic1 = new CompoundTag();
        CompoundTag logic2 = new CompoundTag();
        this.spawnerLogicHunter.writeToNbt(logic1);
        this.spawnerLogicAdvancedHunter.writeToNbt(logic2);
        compound.put("spawner_logic_1", (Tag)logic1);
        compound.put("spawner_logic_2", (Tag)logic2);
        compound.putBoolean("spawn", this.spawn);
        compound.putBoolean("advanced", this.advanced);
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull TentBlockEntity blockEntity) {
        if (blockEntity.spawn) {
            if (level.getGameTime() % 64L == 0L && UtilLib.isInsideStructure(level, pos, (TagKey<Structure>)StructureTags.VILLAGE)) {
                blockEntity.spawn = false;
            }
            blockEntity.spawnerLogicHunter.serverTick(level, pos);
            if (blockEntity.advanced) {
                blockEntity.spawnerLogicAdvancedHunter.serverTick(level, pos);
            }
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.spawnerLogicHunter.setDelayToMin(id, this.level) || this.spawnerLogicAdvancedHunter.setDelayToMin(id, this.level) || super.triggerEvent(id, type);
    }
}

