/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.AlchemicalCauldronBlockEntity;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemicalCauldronBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<AlchemicalCauldronBlock> CODEC = AlchemicalCauldronBlock.simpleCodec(AlchemicalCauldronBlock::new);
    public static final IntegerProperty LIQUID = IntegerProperty.create((String)"liquid", (int)0, (int)2);
    protected static final VoxelShape cauldronShape = AlchemicalCauldronBlock.makeShape();

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape b = Block.box((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape c = Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    public AlchemicalCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIQUID, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource rng) {
        super.animateTick(state, world, pos, rng);
        if ((Integer)state.getValue((Property)LIQUID) == 2) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, (SoundEvent)ModSounds.BOILING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, false);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level p_153212_, @NotNull BlockState p_153213_, @NotNull BlockEntityType<T> p_153214_) {
        return p_153212_.isClientSide() ? null : AlchemicalCauldronBlock.createTickerHelper(p_153214_, (BlockEntityType)((BlockEntityType)ModTiles.ALCHEMICAL_CAULDRON.get()), AlchemicalCauldronBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AlchemicalCauldronBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return cauldronShape;
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(world, blockPos, blockState, entity, stack);
        BlockEntity tile = world.getBlockEntity(blockPos);
        if (entity instanceof Player && tile instanceof AlchemicalCauldronBlockEntity) {
            AlchemicalCauldronBlockEntity cauldronBlockEntity = (AlchemicalCauldronBlockEntity)tile;
            cauldronBlockEntity.setOwnerID((Player)entity);
        }
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING, LIQUID});
    }

    protected void openContainer(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull Player playerEntity) {
        BlockEntity tile = world.getBlockEntity(blockPos);
        if (tile instanceof AlchemicalCauldronBlockEntity) {
            playerEntity.openMenu((MenuProvider)tile);
            playerEntity.awardStat((ResourceLocation)ModStats.INTERACT_ALCHEMICAL_CAULDRON.get());
        }
    }

    @NotNull
    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }
}

