/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blockentity.AlchemyTableBlockEntity;
import de.teamlapen.vampirism.blocks.HorizontalContainerBlock;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableBlock
extends HorizontalContainerBlock {
    public static final BooleanProperty HAS_BOTTLE_INPUT_0 = BooleanProperty.create((String)"has_bottle_input_0");
    public static final BooleanProperty HAS_BOTTLE_INPUT_1 = BooleanProperty.create((String)"has_bottle_input_1");
    public static final BooleanProperty HAS_BOTTLE_OUTPUT_0 = BooleanProperty.create((String)"has_bottle_output_0");
    public static final BooleanProperty HAS_BOTTLE_OUTPUT_1 = BooleanProperty.create((String)"has_bottle_output_1");
    private static final VoxelShape shape = AlchemyTableBlock.makeShape();

    public AlchemyTableBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(0.5f).lightLevel(p_235461_0_ -> 1).noOcclusion(), shape);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_BOTTLE_INPUT_0, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOTTLE_INPUT_1, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOTTLE_OUTPUT_0, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOTTLE_OUTPUT_1, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AlchemyTableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide ? null : AlchemyTableBlock.createTickerHelper(type, (BlockEntityType)ModTiles.ALCHEMICAL_TABLE.get(), AlchemyTableBlockEntity::serverTick);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult rayTrace) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (Helper.isHunter(player)) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity instanceof AlchemyTableBlockEntity) {
                player.openMenu((MenuProvider)((AlchemyTableBlockEntity)tileentity));
                player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_ALCHEMY_TABLE.get());
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.unfamiliar"), true);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state1, boolean p_196243_5_) {
        if (!state.is(state1.getBlock())) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof AlchemyTableBlockEntity) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)((AlchemyTableBlockEntity)tileEntity));
            }
            super.onRemove(state, level, pos, state1, p_196243_5_);
        }
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_BOTTLE_INPUT_0}).add(new Property[]{HAS_BOTTLE_INPUT_1}).add(new Property[]{HAS_BOTTLE_OUTPUT_0}).add(new Property[]{HAS_BOTTLE_OUTPUT_1});
    }

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.625, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.625, (double)0.25, (double)0.9375, (double)0.6875, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.625, (double)0.1875, (double)0.875, (double)0.6875, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.625, (double)0.125, (double)0.8125, (double)0.6875, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.625, (double)0.0, (double)0.6875, (double)0.6875, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.625, (double)0.6875, (double)0.9375, (double)0.6875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.625, (double)0.75, (double)0.875, (double)0.6875, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.625, (double)0.875, (double)0.75, (double)0.6875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.625, (double)0.9375, (double)0.6875, (double)0.6875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.625, (double)0.8125, (double)0.8125, (double)0.6875, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.625, (double)0.0625, (double)0.75, (double)0.6875, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.6875, (double)0.3125, (double)0.4375, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.6875, (double)0.3125, (double)1.0, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.6875, (double)0.25, (double)0.9375, (double)0.75, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.6875, (double)0.1875, (double)0.875, (double)0.75, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.6875, (double)0.125, (double)0.8125, (double)0.75, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.6875, (double)0.0, (double)0.6875, (double)0.75, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.6875, (double)0.6875, (double)0.9375, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.6875, (double)0.6875, (double)0.375, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.6875, (double)0.75, (double)0.375, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.6875, (double)0.75, (double)0.875, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.6875, (double)0.875, (double)0.75, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.6875, (double)0.9375, (double)0.6875, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.6875, (double)0.8125, (double)0.4375, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.6875, (double)0.8125, (double)0.8125, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.6875, (double)0.0625, (double)0.75, (double)0.75, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.6875, (double)0.3125, (double)0.5625, (double)0.75, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.3125, (double)0.25, (double)0.625, (double)0.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0625, (double)0.5625, (double)0.625, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.3125, (double)0.875, (double)0.625, (double)0.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.6875, (double)0.3125, (double)0.625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.875, (double)0.3125, (double)0.25, (double)0.9375, (double)0.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.75, (double)0.0625, (double)0.4375, (double)0.875, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.75, (double)0.3125, (double)0.1875, (double)0.875, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.1875, (double)0.3125, (double)0.875, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.75, (double)0.4375, (double)0.125, (double)0.875, (double)0.5), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.875, (double)0.3125, (double)0.1875, (double)0.9375, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.875, (double)0.0, (double)0.4375, (double)0.9375, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.875, (double)0.125, (double)0.3125, (double)0.9375, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.875, (double)0.0625, (double)0.3125, (double)0.9375, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.875, (double)0.25, (double)0.1875, (double)0.9375, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.875, (double)0.1875, (double)0.1875, (double)0.9375, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.3125, (double)0.0625, (double)0.9375, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.875, (double)0.0, (double)0.5, (double)0.9375, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.875, (double)0.1875, (double)0.375, (double)0.9375, (double)0.3125), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

