/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.BloodGrinderBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrinderBlock
extends VampirismBlockContainer {
    public static final MapCodec<GrinderBlock> CODEC = GrinderBlock.simpleCodec(GrinderBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SOUTH = GrinderBlock.makeShape();
    private static final VoxelShape WEST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape NORTH = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape EAST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape b = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
        VoxelShape b1 = Block.box((double)2.0, (double)3.0, (double)2.0, (double)3.0, (double)4.0, (double)3.0);
        VoxelShape b2 = Block.box((double)13.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)3.0);
        VoxelShape b3 = Block.box((double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)4.0, (double)14.0);
        VoxelShape b4 = Block.box((double)13.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)14.0);
        VoxelShape c = Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
        VoxelShape d1 = Block.box((double)5.0, (double)7.0, (double)2.0, (double)11.0, (double)12.0, (double)14.0);
        VoxelShape d2 = Block.box((double)2.0, (double)7.0, (double)5.0, (double)14.0, (double)12.0, (double)11.0);
        VoxelShape d3 = Block.box((double)3.0, (double)7.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0);
        VoxelShape d4 = Block.box((double)4.0, (double)7.0, (double)3.0, (double)12.0, (double)12.0, (double)13.0);
        VoxelShape d5 = Shapes.or((VoxelShape)d1, (VoxelShape)d2);
        VoxelShape d6 = Shapes.or((VoxelShape)d3, (VoxelShape)d4);
        VoxelShape d = Shapes.or((VoxelShape)d5, (VoxelShape)d6);
        VoxelShape e = Block.box((double)8.0, (double)12.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape e1 = Block.box((double)4.0, (double)12.0, (double)5.0, (double)7.0, (double)13.0, (double)6.0);
        VoxelShape e2 = Block.box((double)5.0, (double)12.0, (double)4.0, (double)6.0, (double)13.0, (double)7.0);
        VoxelShape e3 = Shapes.or((VoxelShape)e1, (VoxelShape)e2);
        VoxelShape e4 = Shapes.or((VoxelShape)e, (VoxelShape)e3);
        VoxelShape f = Shapes.or((VoxelShape)a, (VoxelShape)b);
        VoxelShape g = Shapes.or((VoxelShape)c, (VoxelShape)d);
        VoxelShape g1 = Shapes.or((VoxelShape)b1, (VoxelShape)b2);
        VoxelShape g2 = Shapes.or((VoxelShape)b3, (VoxelShape)b4);
        VoxelShape g3 = Shapes.or((VoxelShape)g1, (VoxelShape)g2);
        VoxelShape g4 = Shapes.or((VoxelShape)g, (VoxelShape)g3);
        VoxelShape h = Shapes.or((VoxelShape)f, (VoxelShape)g4);
        return Shapes.or((VoxelShape)h, (VoxelShape)e4);
    }

    public GrinderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BloodGrinderBlockEntity(pos, state);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_BLOOD_GRINDER.get());
        player.openMenu(world.getBlockEntity(pos) instanceof BloodGrinderBlockEntity ? (BloodGrinderBlockEntity)world.getBlockEntity(pos) : null);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void clearContainer(BlockState state, @NotNull Level worldIn, BlockPos pos) {
        this.dropInventoryTileEntityItems(worldIn, pos);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level p_153212_, @NotNull BlockState p_153213_, @NotNull BlockEntityType<T> p_153214_) {
        return p_153212_.isClientSide() ? null : GrinderBlock.createTickerHelper(p_153214_, (BlockEntityType)((BlockEntityType)ModTiles.GRINDER.get()), BloodGrinderBlockEntity::serverTick);
    }
}

