/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.PotionTableBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionTableBlock
extends VampirismBlockContainer {
    public static final MapCodec<PotionTableBlock> CODEC = PotionTableBlock.simpleCodec(PotionTableBlock::new);
    protected static final VoxelShape shape = PotionTableBlock.makeShape();

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape b = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape c = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape d = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d});
    }

    public PotionTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PotionTableBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState blockState, LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(world, blockPos, blockState, entity, stack);
        BlockEntity tile = world.getBlockEntity(blockPos);
        if (entity instanceof Player && tile instanceof PotionTableBlockEntity) {
            ((PotionTableBlockEntity)tile).setOwnerID((Player)entity);
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        PotionTableBlockEntity potionTable;
        BlockEntity tile;
        if (!worldIn.isClientSide && player instanceof ServerPlayer && (tile = worldIn.getBlockEntity(pos)) instanceof PotionTableBlockEntity && (potionTable = (PotionTableBlockEntity)tile).canOpen(player)) {
            player.openMenu((MenuProvider)potionTable, buffer -> buffer.writeBoolean(potionTable.isExtended()));
            player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_POTION_TABLE.get());
        }
        return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    @Override
    protected void clearContainer(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof PotionTableBlockEntity) {
            for (int i = 0; i < 8; ++i) {
                this.dropItem(worldIn, pos, ((PotionTableBlockEntity)te).removeItemNoUpdate(i));
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return PotionTableBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.POTION_TABLE.get()), PotionTableBlockEntity::tick);
    }
}

