/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.extensions;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.mixin.client.accessor.EffectRenderingInventoryScreenAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import org.jetbrains.annotations.NotNull;

public class EffectExtensions {
    public static final IClientMobEffectExtensions SANGUINARE = new IClientMobEffectExtensions(){

        public boolean isVisibleInGui(MobEffectInstance instance) {
            return false;
        }

        public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics graphics, int x, int y, int blitOffset) {
            Component component = ((EffectRenderingInventoryScreenAccessor)screen).invoke_getEffectName(instance);
            graphics.drawString(screen.font, component, x + 10 + 18, y + 6, 0xFFFFFF, true);
            graphics.drawString(screen.font, "**:**", x + 10 + 18, y + 6 + 10, 0x7F7F7F, true);
            return true;
        }
    };
    public static final IClientMobEffectExtensions NIGHT_VISION = new IClientMobEffectExtensions(){

        public boolean isVisibleInInventory(@NotNull MobEffectInstance instance) {
            if (instance instanceof EffectInstanceWithSource) {
                EffectInstanceWithSource withSource = (EffectInstanceWithSource)instance;
                return !withSource.hasSource() || !VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)withSource.getSource());
            }
            return true;
        }

        public boolean isVisibleInGui(@NotNull MobEffectInstance instance) {
            if (instance instanceof EffectInstanceWithSource) {
                EffectInstanceWithSource withSource = (EffectInstanceWithSource)instance;
                return !withSource.hasSource() || !VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)withSource.getSource());
            }
            return true;
        }

        public boolean renderInventoryIcon(@NotNull MobEffectInstance instance, @NotNull EffectRenderingInventoryScreen<?> screen, @NotNull GuiGraphics graphics, int x, int y, int blitOffset) {
            if (instance instanceof EffectInstanceWithSource) {
                EffectInstanceWithSource withSource = (EffectInstanceWithSource)instance;
                return withSource.hasSource() && VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)withSource.getSource());
            }
            return false;
        }

        public boolean renderInventoryText(@NotNull MobEffectInstance instance, @NotNull EffectRenderingInventoryScreen<?> screen, @NotNull GuiGraphics graphics, int x, int y, int blitOffset) {
            if (instance instanceof EffectInstanceWithSource) {
                EffectInstanceWithSource withSource = (EffectInstanceWithSource)instance;
                return withSource.hasSource() && VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)withSource.getSource());
            }
            return false;
        }

        public boolean renderGuiIcon(@NotNull MobEffectInstance instance, @NotNull Gui gui, @NotNull GuiGraphics graphics, int x, int y, float z, float alpha) {
            if (instance instanceof EffectInstanceWithSource) {
                EffectInstanceWithSource withSource = (EffectInstanceWithSource)instance;
                return withSource.hasSource() && VReference.PERMANENT_INVISIBLE_MOB_EFFECT.equals((Object)withSource.getSource());
            }
            return false;
        }
    };
    public static final IClientMobEffectExtensions POISON = new IClientMobEffectExtensions(){

        public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics graphics, int x, int y, int blitOffset) {
            MutableComponent component = ((MutableComponent)((EffectRenderingInventoryScreenAccessor)screen).invoke_getEffectName(instance)).append(" - ").append(MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)Minecraft.getInstance().level.tickRateManager().tickrate()));
            graphics.drawString(screen.font, (Component)component, x + 10 + 18, y + 6, 0xFFFFFF, true);
            MutableComponent note = Component.translatable((String)"effect.vampirism.wrong_equipment.note").withStyle(ChatFormatting.DARK_RED);
            graphics.drawString(screen.font, (Component)note, x + 10 + 18, y + 6 + 10, -1, true);
            return true;
        }
    };
}

