/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.RegUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ActionCooldownOverlay
implements LayeredDraw.Layer {
    private final Minecraft mc = Minecraft.getInstance();

    public void render(@NotNull GuiGraphics graphics, DeltaTracker partialTicks) {
        if (this.mc.player != null && !((Boolean)VampirismConfig.CLIENT.disableHudActionCooldownRendering.get()).booleanValue()) {
            VampirismAPI.factionPlayerHandler((Player)this.mc.player).getCurrentFactionPlayer().ifPresent(factionPlayer -> {
                IActionHandler actionHandler = factionPlayer.getActionHandler();
                int y = this.mc.getWindow().getGuiScaledHeight() - 27;
                int x = this.mc.getWindow().getGuiScaledWidth() - 12 - 16;
                for (IAction action : factionPlayer.getActionHandler().getUnlockedActions()) {
                    if (!action.showHudCooldown((Player)this.mc.player) || !actionHandler.isActionOnCooldown(action)) continue;
                    ResourceLocation id = RegUtil.id(action);
                    ResourceLocation loc = id.withPath("textures/actions/" + id.getPath() + ".png");
                    int perc = (int)((1.0f + actionHandler.getPercentageForAction(action)) * 16.0f);
                    graphics.fillGradient(x, y + perc, x + 16, y + 16, 0x44888888, 0x44888888);
                    graphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
                    graphics.blit(loc, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    x -= 17;
                }
            });
        }
    }
}

