/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirePlayerAppearanceScreen
extends AppearanceScreen<Player> {
    private static final Component NAME = Component.translatable((String)"gui.vampirism.appearance");
    private float[] color;
    private int fangType;
    private int eyeType;
    private boolean glowingEyes;
    private boolean titleGender;
    private HoverList<?> eyeList;
    private HoverList<?> fangList;
    private ExtendedButton eyeButton;
    private ExtendedButton fangButton;
    private Checkbox glowingEyesButton;
    private Checkbox titleGenderButton;

    public VampirePlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, Minecraft.getInstance().player, backScreen);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.fangList.mouseDragged(mouseX, mouseY, button, dragX, dragY) && !this.eyeList.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void removed() {
        VampirismMod.proxy.sendToServer(new ServerboundAppearancePacket(((Player)this.entity).getId(), "", this.fangType, this.eyeType, this.glowingEyes ? 1 : 0, this.titleGender ? 1 : 0));
        super.removed();
    }

    @Override
    protected void init() {
        super.init();
        VampirismPlayerAttributes attributes = VampirismPlayerAttributes.get((Player)Minecraft.getInstance().player);
        IPlayableFaction<?> f = attributes.faction;
        this.color = f == null ? Color.GRAY.getRGBColorComponents() : new Color(f.getColor()).getRGBColorComponents();
        VampirePlayerSpecialAttributes vampAtt = attributes.getVampSpecial();
        this.fangType = vampAtt.fangType;
        this.eyeType = vampAtt.eyeType;
        this.glowingEyes = vampAtt.glowingEyes;
        this.titleGender = FactionPlayerHandler.get((Player)Minecraft.getInstance().player).titleGender() == IPlayableFaction.TitleGender.FEMALE;
        this.titleGenderButton = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"gui.vampirism.appearance.title_gender"), (Font)this.minecraft.font).pos(this.guiLeft + 20, this.guiTop + 91).selected(this.titleGender).onValueChange((button, selected) -> {
            this.titleGender = selected;
            FactionPlayerHandler.get((Player)this.entity).setTitleGender(this.titleGender);
        }).build());
        this.glowingEyesButton = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"gui.vampirism.appearance.glowing_eye"), (Font)this.minecraft.font).pos(this.guiLeft + 20, this.guiTop + 70).selected(this.glowingEyes).onValueChange((button, selected) -> {
            this.glowingEyes = selected;
            VampirePlayer.get((Player)this.entity).setGlowingEyes(this.glowingEyes);
        }).build());
        this.fangList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 50 + 19, 99, 80).componentsWithClickAndHover(IntStream.range(0, 7).mapToObj(type -> Component.translatable((String)"gui.vampirism.appearance.fang").append(" " + (type + 1))).toList(), this::fang, this::hoverFang).build());
        this.fangButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.fangList.getX(), this.fangList.getY() - 20, this.fangList.getWidth(), 20, (Component)Component.literal((String)""), b -> this.setFangListVisibility(!this.fangList.visible)));
        this.eyeList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 30 + 19, 99, 100).componentsWithClickAndHover(IntStream.range(0, 17).mapToObj(type -> Component.translatable((String)"gui.vampirism.appearance.eye").append(" " + (type + 1))).toList(), this::eye, this::hoverEye).build());
        this.eyeButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.eyeList.getX(), this.eyeList.getY() - 20, this.eyeList.getWidth(), 20, (Component)Component.literal((String)""), b -> this.setEyeListVisibility(!this.eyeList.visible)));
        this.setEyeListVisibility(false);
        this.setFangListVisibility(false);
    }

    @Override
    protected void renderGuiBackground(@NotNull GuiGraphics graphics) {
        graphics.setColor(this.color[0], this.color[1], this.color[2], 1.0f);
        super.renderGuiBackground(graphics);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void eye(int eyeType) {
        VampirePlayer vampire = VampirePlayer.get((Player)this.minecraft.player);
        this.eyeType = eyeType;
        vampire.setEyeType(this.eyeType);
        this.setEyeListVisibility(false);
    }

    private void fang(int fangType) {
        VampirePlayer vampire = VampirePlayer.get((Player)this.minecraft.player);
        this.fangType = fangType;
        vampire.setFangType(this.fangType);
        this.setFangListVisibility(false);
    }

    private void hoverEye(int eyeType, boolean hovered) {
        VampirePlayer vampire = VampirePlayer.get((Player)this.minecraft.player);
        if (hovered) {
            vampire.setEyeType(eyeType);
        } else if (vampire.getEyeType() == eyeType) {
            vampire.setEyeType(this.eyeType);
        }
    }

    private void hoverFang(int fangType, boolean hovered) {
        VampirePlayer vampire = VampirePlayer.get((Player)this.minecraft.player);
        if (hovered) {
            vampire.setFangType(fangType);
        } else if (vampire.getFangType() == fangType) {
            vampire.setFangType(this.fangType);
        }
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.setMessage((Component)Component.translatable((String)"gui.vampirism.appearance.eye").append(" " + (this.eyeType + 1)));
        this.eyeList.visible = show;
        this.fangButton.visible = !show;
        this.glowingEyesButton.visible = !show;
        boolean bl = this.titleGenderButton.visible = !show;
        if (show) {
            this.fangList.visible = false;
        }
    }

    private void setFangListVisibility(boolean show) {
        this.fangButton.setMessage((Component)Component.translatable((String)"gui.vampirism.appearance.fang").append(" " + (this.fangType + 1)));
        this.fangList.visible = show;
        this.glowingEyesButton.visible = !show;
        boolean bl = this.titleGenderButton.visible = !show;
        if (show) {
            this.eyeList.visible = false;
        }
    }
}

