/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;

public class CoffinModel
extends Model {
    private static final String LEFT_PLATE = "left_plate";
    private static final String RIGHT_PLATE = "right_plate";
    private static final String BACK_PLATE = "back_plate";
    private static final String TOP_PLATE = "top_plate";
    private static final String BOTTOM_PLATE = "bottom_plate";
    private static final String LEFT_LID = "left_lid";
    private static final String RIGHT_LID = "right_lid";
    private static final String LEFT_HANDLE = "left_handle";
    private static final String RIGHT_HANDLE = "right_handle";
    @NotNull
    private final ModelPart leftPlate;
    @NotNull
    private final ModelPart rightPlate;
    @NotNull
    private final ModelPart backPlate;
    @NotNull
    private final ModelPart topPlate;
    @NotNull
    private final ModelPart bottomPlate;
    @NotNull
    private final ModelPart leftLid;
    @NotNull
    private final ModelPart rightLid;
    @NotNull
    private final ModelPart leftHandle;
    @NotNull
    private final ModelPart rightHandle;
    @NotNull
    private final List<ModelPart> modelParts;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        part.addOrReplaceChild(LEFT_PLATE, CubeListBuilder.create().texOffs(0, 64).mirror().addBox(7.0f, -12.0f, 0.0f, 1.0f, 12.0f, 32.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)-8.0f));
        part.addOrReplaceChild(RIGHT_PLATE, CubeListBuilder.create().texOffs(66, 64).mirror().addBox(-8.0f, -12.0f, 0.0f, 1.0f, 12.0f, 32.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)-8.0f));
        part.addOrReplaceChild(BACK_PLATE, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-8.0f, 0.0f, 0.0f, 16.0f, 1.0f, 32.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)-8.0f));
        part.addOrReplaceChild(TOP_PLATE, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-7.0f, -12.0f, 31.0f, 14.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)-8.0f));
        part.addOrReplaceChild(BOTTOM_PLATE, CubeListBuilder.create().texOffs(0, 15).mirror().addBox(-7.0f, -11.0f, 0.0f, 14.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)-8.0f));
        part.addOrReplaceChild(LEFT_LID, CubeListBuilder.create().texOffs(0, 33).mirror().addBox(0.0f, 0.0f, 0.0f, 7.0f, 1.0f, 30.0f), PartPose.offset((float)-7.0f, (float)11.0f, (float)-7.0f));
        part.addOrReplaceChild(RIGHT_LID, CubeListBuilder.create().texOffs(74, 33).mirror().addBox(-7.0f, 0.0f, 0.0f, 7.0f, 1.0f, 30.0f), PartPose.offset((float)7.0f, (float)11.0f, (float)-7.0f));
        part.addOrReplaceChild(LEFT_HANDLE, CubeListBuilder.create().texOffs(64, 0).mirror().addBox(5.5f, -0.5f, 15.0f, 1.0f, 1.0f, 4.0f), PartPose.offset((float)-7.0f, (float)11.0f, (float)-7.0f));
        part.addOrReplaceChild(RIGHT_HANDLE, CubeListBuilder.create().texOffs(74, 0).mirror().addBox(-6.5f, -0.5f, 15.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)7.0f, (float)11.0f, (float)-7.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)256, (int)128);
    }

    public CoffinModel(@NotNull ModelPart part) {
        super(RenderType::entitySolid);
        this.leftPlate = part.getChild(LEFT_PLATE);
        this.rightPlate = part.getChild(RIGHT_PLATE);
        this.backPlate = part.getChild(BACK_PLATE);
        this.topPlate = part.getChild(TOP_PLATE);
        this.bottomPlate = part.getChild(BOTTOM_PLATE);
        this.leftLid = part.getChild(LEFT_LID);
        this.rightLid = part.getChild(RIGHT_LID);
        this.leftHandle = part.getChild(LEFT_HANDLE);
        this.rightHandle = part.getChild(RIGHT_HANDLE);
        this.modelParts = ImmutableList.of((Object)this.leftPlate, (Object)this.rightPlate, (Object)this.backPlate, (Object)this.topPlate, (Object)this.bottomPlate, (Object)this.leftLid, (Object)this.rightLid, (Object)this.leftHandle, (Object)this.rightHandle);
    }

    public void renderToBuffer(@NotNull PoseStack matrixStack, @NotNull VertexConsumer iVertexBuilder, int packedLight, int overlay, int color) {
        this.modelParts.forEach(part -> part.render(matrixStack, iVertexBuilder, packedLight, overlay, color));
    }

    public void rotateLid(float angle) {
        this.leftLid.zRot = this.leftHandle.zRot = -angle;
        this.rightLid.zRot = this.rightHandle.zRot = angle;
    }
}

