/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.armor;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import de.teamlapen.vampirism.util.MixinHooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class CloakModel
extends VampirismArmorModel {
    private static final String CLOAK_BACK = "cloak_back";
    private static final String LEFT_LONG = "left_long";
    private static final String RIGHT_MEDIUM = "right_medium";
    private static final String LEFT_MEDIUM = "left_medium";
    private static final String RIGHT_SHORT = "right_short";
    private static final String LEFT_SHORT = "left_short";
    private static final String RIGHT_LONG = "right_long";
    private static final String SHOULDER_LEFT = "shoulder_left";
    private static final String SHOULDER_RIGHT = "shoulder_right";
    private static CloakModel cloakItemModel;
    @NotNull
    private final ModelPart cloakback;
    @NotNull
    private final ModelPart leftlong;
    @NotNull
    private final ModelPart rightmedium;
    @NotNull
    private final ModelPart leftmedium;
    @NotNull
    private final ModelPart rightshort;
    @NotNull
    private final ModelPart leftshort;
    @NotNull
    private final ModelPart rightlong;
    @NotNull
    private final ModelPart shoulderright;
    @NotNull
    private final ModelPart shoulderleft;

    public static CloakModel getAdjustedCloak(HumanoidModel<?> wearerModel, LivingEntity entity) {
        if (cloakItemModel == null) {
            cloakItemModel = new CloakModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModEntitiesRender.CLOAK));
        }
        cloakItemModel.copyFromHumanoid(wearerModel);
        cloakItemModel.setupAnimation(entity);
        return cloakItemModel;
    }

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        part.addOrReplaceChild(CLOAK_BACK, CubeListBuilder.create().texOffs(0, 48).mirror().addBox(-4.0f, 0.0f, 2.0f, 8.0f, 15.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(LEFT_LONG, CubeListBuilder.create().texOffs(18, 48).mirror().addBox(4.0f, 0.0f, 2.0f, 1.0f, 15.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(RIGHT_MEDIUM, CubeListBuilder.create().texOffs(22, 50).addBox(-5.0f, 0.0f, 1.0f, 1.0f, 13.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(LEFT_MEDIUM, CubeListBuilder.create().texOffs(22, 50).mirror().addBox(4.0f, 0.0f, 1.0f, 1.0f, 13.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(RIGHT_SHORT, CubeListBuilder.create().texOffs(26, 52).addBox(-5.0f, 0.0f, 0.0f, 1.0f, 11.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(LEFT_SHORT, CubeListBuilder.create().texOffs(26, 52).addBox(4.0f, 0.0f, 0.0f, 1.0f, 11.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(RIGHT_LONG, CubeListBuilder.create().texOffs(18, 48).addBox(-5.0f, 0.0f, 2.0f, 1.0f, 15.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(SHOULDER_RIGHT, CubeListBuilder.create().texOffs(30, 60).addBox(-4.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.offset((float)-5.0f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(SHOULDER_LEFT, CubeListBuilder.create().texOffs(30, 60).mirror().addBox(3.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.offset((float)-5.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public CloakModel(@NotNull ModelPart part) {
        this.cloakback = part.getChild(CLOAK_BACK);
        this.leftlong = part.getChild(LEFT_LONG);
        this.rightmedium = part.getChild(RIGHT_MEDIUM);
        this.leftmedium = part.getChild(LEFT_MEDIUM);
        this.rightshort = part.getChild(RIGHT_SHORT);
        this.rightlong = part.getChild(RIGHT_LONG);
        this.leftshort = part.getChild(LEFT_SHORT);
        this.shoulderleft = part.getChild(SHOULDER_LEFT);
        this.shoulderright = part.getChild(SHOULDER_RIGHT);
    }

    private void setupAnimation(LivingEntity entity) {
        Entity entity2;
        boolean shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
        float f = Mth.rotLerp((float)MixinHooks.armorLayerPartialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float f1 = Mth.rotLerp((float)MixinHooks.armorLayerPartialTicks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float f2 = f1 - f;
        float f6 = Mth.lerp((float)MixinHooks.armorLayerPartialTicks, (float)entity.xRotO, (float)entity.getXRot());
        if (shouldSit && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            f = Mth.rotLerp((float)MixinHooks.armorLayerPartialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)entity)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.isAlive()) {
            f8 = entity.walkAnimation.speed(MixinHooks.armorLayerPartialTicks);
            f5 = entity.walkAnimation.position(MixinHooks.armorLayerPartialTicks);
            if (entity.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        cloakItemModel.setupAnim(entity, f5, f8, (float)entity.tickCount + MixinHooks.armorLayerPartialTicks, f2, f6);
    }

    public void setupAnim(@NotNull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rotation;
        boolean flag = entity != null && entity.getFallFlyingTicks() > 4;
        float f6 = 1.0f;
        if (flag) {
            f6 = (float)(entity.getDeltaMovement().x * entity.getDeltaMovement().x + entity.getDeltaMovement().y * entity.getDeltaMovement().y + entity.getDeltaMovement().z * entity.getDeltaMovement().z);
            f6 /= 0.2f;
            f6 = f6 * f6 * f6;
        }
        if (f6 < 1.0f) {
            f6 = 1.0f;
        }
        if ((rotation = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * (limbSwingAmount / 1.8f) / f6) < 0.0f) {
            rotation *= -1.0f;
        }
        this.cloakback.xRot = 0.0872665f + rotation / 3.0f;
        this.leftlong.xRot = 0.0872665f + rotation / 3.0f;
        this.rightlong.xRot = 0.0872665f + rotation / 3.0f;
        this.leftmedium.xRot = 0.0872665f + rotation / 3.0f;
        this.rightmedium.xRot = 0.0872665f + rotation / 3.0f;
        this.rightshort.xRot = 0.0872665f + rotation / 3.0f;
        this.leftshort.xRot = 0.0872665f + rotation / 3.0f;
        if (entity.isCrouching()) {
            this.cloakback.xRot += 0.5f;
            this.leftlong.xRot += 0.5f;
            this.rightlong.xRot += 0.5f;
            this.leftmedium.xRot += 0.5f;
            this.rightmedium.xRot += 0.5f;
            this.leftshort.xRot += 0.5f;
            this.rightshort.xRot += 0.5f;
        }
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getBodyModels() {
        return ImmutableList.of((Object)this.cloakback, (Object)this.leftlong, (Object)this.rightmedium, (Object)this.leftmedium, (Object)this.rightshort, (Object)this.leftshort, (Object)this.rightlong, (Object)this.shoulderright, (Object)this.shoulderleft);
    }
}

