/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.blockentity.BloodContainerBlockEntity;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.items.component.ContainedFluid;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BakedBloodContainerModel
implements IDynamicBakedModel {
    public static final int FLUID_LEVELS = 14;
    public static final BakedModel[] BLOOD_FLUID_MODELS = new BakedModel[14];
    public static final BakedModel[] IMPURE_BLOOD_FLUID_MODELS = new BakedModel[14];
    private static final ItemOverrides overrideList = new CustomItemOverride();
    private final BakedModel baseModel;
    private boolean impure;
    private int fluidLevel = 0;
    private boolean item;

    public BakedBloodContainerModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public BakedBloodContainerModel(BakedModel baseModel, @NotNull FluidStack stack) {
        this.baseModel = baseModel;
        this.impure = stack.getFluid().equals(ModFluids.IMPURE_BLOOD.get());
        this.fluidLevel = Mth.clamp((int)(stack.getAmount() / 900), (int)1, (int)14) - 1;
        this.item = true;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return overrideList;
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.baseModel.getTransforms();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.baseModel.getQuads(state, side, rand));
        if (!this.item) {
            Integer level = (Integer)extraData.get(BloodContainerBlockEntity.FLUID_LEVEL_PROP);
            Boolean impure = (Boolean)extraData.get(BloodContainerBlockEntity.FLUID_IMPURE);
            if (impure != null && level != null && level > 0 && level <= 14) {
                quads.addAll((impure != false ? IMPURE_BLOOD_FLUID_MODELS[level - 1] : BLOOD_FLUID_MODELS[level - 1]).getQuads(state, side, rand, ModelData.EMPTY, renderType));
            }
        } else {
            quads.addAll((this.impure ? IMPURE_BLOOD_FLUID_MODELS[this.fluidLevel] : BLOOD_FLUID_MODELS[this.fluidLevel]).getQuads(state, side, rand, ModelData.EMPTY, renderType));
        }
        return quads;
    }

    public boolean isCustomRenderer() {
        return this.baseModel.isCustomRenderer();
    }

    public boolean useAmbientOcclusion() {
        return this.baseModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.baseModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.baseModel.usesBlockLight();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.baseModel.getRenderTypes(state, rand, data);
    }

    private static class CustomItemOverride
    extends ItemOverrides {
        CustomItemOverride() {
        }

        public BakedModel resolve(@NotNull BakedModel originalModel, @NotNull ItemStack stack, ClientLevel world, LivingEntity entity, int p) {
            FluidStack fluidStack;
            if (originalModel instanceof BakedBloodContainerModel && !(fluidStack = ContainedFluid.get(stack)).isEmpty()) {
                return new BakedBloodContainerModel(originalModel, fluidStack);
            }
            return originalModel;
        }
    }
}

