/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.entity.IDefaultTaskMasterEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerType;
import org.jetbrains.annotations.NotNull;

public class TaskMasterTypeLayer<T extends Mob>
extends RenderLayer<T, VillagerModel<T>> {
    private final ResourceLocation additionalOverlay;

    public TaskMasterTypeLayer(@NotNull RenderLayerParent<T, VillagerModel<T>> entityRendererIn, ResourceLocation additionalOverlay) {
        super(entityRendererIn);
        this.additionalOverlay = additionalOverlay;
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entityIn.isInvisible()) {
            VillagerType type = ((IDefaultTaskMasterEntity)entityIn).getBiomeType();
            VillagerModel m = (VillagerModel)this.getParentModel();
            TaskMasterTypeLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)this.deriveTypeTextureOverlay(BuiltInRegistries.VILLAGER_TYPE.getKey((Object)type)), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entityIn, (int)-1);
            TaskMasterTypeLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)this.additionalOverlay, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entityIn, (int)-1);
        }
    }

    @NotNull
    private ResourceLocation deriveTypeTextureOverlay(@NotNull ResourceLocation id) {
        return id.withPath("textures/entity/villager/type/" + id.getPath() + ".png");
    }
}

