/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LordCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_FACTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.lord.no_faction"));
    private static final SimpleCommandExceptionType LEVEL_UP_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.lord.level_failed"));
    private static final SimpleCommandExceptionType LORD_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.base.lord.failed"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"lord-level").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LordCommand.setLevel((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> LordCommand.setLevel((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), EntityArgument.getPlayers((CommandContext)context, (String)"player")))));
    }

    private static int setLevel(@NotNull CommandContext<CommandSourceStack> context, int level, @NotNull Collection<ServerPlayer> players) throws CommandSyntaxException {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            if (handler.getCurrentFaction() == null) {
                throw NO_FACTION.create();
            }
            int maxLevel = handler.getCurrentFaction().getHighestReachableLevel();
            if (handler.getCurrentLevel() == maxLevel && !handler.setFactionLevel(handler.getCurrentFaction(), maxLevel)) {
                throw LEVEL_UP_FAILED.create();
            }
            if (!handler.setLordLevel(Math.min(level, handler.getCurrentFaction().getHighestLordLevel()))) {
                throw LORD_FAILED.create();
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.base.lord.successful", (Object[])new Object[]{player.getName(), handler.getCurrentFaction().getName(), handler.getLordLevel()}), true);
        }
        return 0;
    }
}

